/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.modules.HUDOreDictItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.OreDictItemSinkModuleInHand;
import logisticspipes.network.guis.module.inpipe.OreDictItemSinkModuleSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.OreDictItemSinkList;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.StringListProperty;

public class ModuleOreDictItemSink
extends LogisticsModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
Gui {
    public final StringListProperty oreList = new StringListProperty("");
    private Map<Item, Set<Integer>> oreItemIdMap;
    private final IHUDModuleRenderer HUD = new HUDOreDictItemSink(this);
    private List<ItemIdentifierStack> oreHudList;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;

    public static String getName() {
        return "item_sink_oredict";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleOreDictItemSink.getName();
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return Collections.singletonList(this.oreList);
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.OreDictItemSink, 0, true, false, 5, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        Set<Integer> damageSet;
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this.oreItemIdMap == null) {
            this.buildOreItemIdMap();
        }
        if ((damageSet = this.oreItemIdMap.get(item.item)) == null) {
            return null;
        }
        if (damageSet.isEmpty() || damageSet.contains(item.itemDamage)) {
            return this._sinkReply;
        }
        return null;
    }

    public List<ItemIdentifierStack> getHudItemList() {
        if (this.oreItemIdMap == null) {
            this.buildOreItemIdMap();
        }
        return this.oreHudList;
    }

    private void buildOreItemIdMap() {
        this.oreItemIdMap = new HashMap<Item, Set<Integer>>();
        this.oreHudList = new ArrayList<ItemIdentifierStack>(this.oreList.size());
        for (String orename : this.oreList) {
            NonNullList items = OreDictionary.getOres((String)orename);
            ItemStack stackForHud = ItemStack.field_190927_a;
            for (ItemStack stack : items) {
                if (stackForHud.func_190926_b()) {
                    stackForHud = stack;
                }
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    this.oreItemIdMap.put(stack.func_77973_b(), new TreeSet());
                    continue;
                }
                Set<Integer> damageSet = this.oreItemIdMap.get(stack.func_77973_b());
                if (damageSet == null) {
                    damageSet = new TreeSet<Integer>();
                    damageSet.add(stack.func_77952_i());
                    this.oreItemIdMap.put(stack.func_77973_b(), damageSet);
                    continue;
                }
                if (damageSet.isEmpty()) continue;
                damageSet.add(stack.func_77952_i());
            }
            if (!stackForHud.func_190926_b()) {
                ItemStack t = stackForHud.func_77946_l();
                if (t.func_77952_i() == Short.MAX_VALUE) {
                    t.func_77964_b(0);
                }
                this.oreHudList.add(new ItemIdentifierStack(ItemIdentifier.get(t), 1));
                continue;
            }
            this.oreHudList.add(new ItemIdentifierStack(ItemIdentifier.get(Item.func_150898_a((Block)Blocks.field_150480_ab), 0, null), 1));
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < this.oreList.size(); ++i) {
            String val;
            String key = "Ore" + i;
            if (!tag.func_74764_b(key) || (val = tag.func_74779_i(key)).isEmpty()) continue;
            this.oreList.set(i, val);
        }
        this.oreItemIdMap = null;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Ores: ");
        list.addAll(this.oreList);
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OreDictItemSinkList.class).setTag(nbt).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    public void OreListChanged() {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(OreDictItemSinkList.class).setTag(nbt).setModulePos(this), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(PacketHandler.getPacket(OreDictItemSinkList.class).setTag(nbt).setModulePos(this));
        }
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return NewGuiHandler.getGui(OreDictItemSinkModuleSlot.class).setNbt(nbt);
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(OreDictItemSinkModuleInHand.class);
    }
}

