/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis;

import javax.annotation.Nonnull;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import network.rs485.logisticspipes.guidebook.ItemGuideBook;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class OpenGuideBook
extends ModernPacket {
    private EnumHand hand;
    private ItemStack stack;

    public OpenGuideBook(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.hand = input.readEnum(EnumHand.class);
        this.stack = input.readItemStack();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeEnum(this.hand);
        output.writeItemStack(this.stack);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ItemGuideBook.openGuideBook(this.hand, this.stack);
    }

    @Override
    public ModernPacket template() {
        return new OpenGuideBook(this.getId());
    }

    @Nonnull
    public OpenGuideBook setHand(@Nonnull EnumHand hand) {
        this.hand = hand;
        return this;
    }

    @Nonnull
    public OpenGuideBook setStack(@Nonnull ItemStack stack) {
        this.stack = stack;
        return this;
    }
}

