/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CraftingCycleRecipe
extends CoordinatesPacket {
    private boolean down;

    public CraftingCycleRecipe(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity table = this.getTileAs(player.func_130014_f_(), TileEntity.class);
        if (table instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)table).cycleRecipe(this.down);
        } else if (table instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)table).pipe instanceof PipeBlockRequestTable) {
            ((PipeBlockRequestTable)((LogisticsTileGenericPipe)table).pipe).cycleRecipe(this.down);
        }
    }

    @Override
    public ModernPacket template() {
        return new CraftingCycleRecipe(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.down);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.down = input.readBoolean();
    }

    public boolean isDown() {
        return this.down;
    }

    public CraftingCycleRecipe setDown(boolean down) {
        this.down = down;
        return this;
    }
}

