/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import java.util.BitSet;
import logisticspipes.interfaces.IFuzzySlot;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class FuzzySlotSettingsPacket
extends ModernPacket {
    private int slotNumber;
    private BitSet flags;

    public FuzzySlotSettingsPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.slotNumber = input.readInt();
        this.flags = input.readBitSet();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (player.field_71070_bA != null && player.field_71070_bA.func_75139_a(this.slotNumber) instanceof IFuzzySlot) {
            ((IFuzzySlot)player.field_71070_bA.func_75139_a(this.slotNumber)).getFuzzyFlags().replaceWith(this.flags);
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.slotNumber);
        output.writeBitSet(this.flags);
    }

    @Override
    public ModernPacket template() {
        return new FuzzySlotSettingsPacket(this.getId());
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public FuzzySlotSettingsPacket setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
        return this;
    }

    public BitSet getFlags() {
        return this.flags;
    }

    public FuzzySlotSettingsPacket setFlags(BitSet flags) {
        this.flags = flags;
        return this;
    }
}

