/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.packets.pipe.SlotFinderActivatePacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.StaticResolve;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SlotFinderOpenGuiPacket
extends ModuleCoordinatesPacket {
    private int slot;

    public SlotFinderOpenGuiPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        int i;
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        boolean openedGui = false;
        LogisticsTileGenericPipe genericPipe = this.getPipe(player.field_70170_p, CoordinatesPacket.LTGPCompletionCheck.PIPE);
        if (genericPipe.isRoutingPipe()) {
            openedGui = genericPipe.getRoutingPipe().getAvailableAdjacent().inventories().stream().filter(neighbor -> LPNeighborTileEntityKt.getInventoryUtil(neighbor) instanceof ISpecialInsertion).anyMatch(neighbor -> {
                BlockPos blockPos;
                IBlockState blockState;
                for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                    if (!provider.canOpenGui((TileEntity)neighbor.getTileEntity())) continue;
                    return true;
                }
                Block block = neighbor.getTileEntity().func_145838_q();
                if (!block.isAir(blockState = player.field_70170_p.func_180495_p(blockPos = neighbor.getTileEntity().func_174877_v()), (IBlockAccess)player.field_70170_p, blockPos)) {
                    int xCoord = blockPos.func_177958_n();
                    int yCoord = blockPos.func_177956_o();
                    int zCoord = blockPos.func_177952_p();
                    if (SimpleServiceLocator.enderStorageProxy.isEnderChestBlock(block)) {
                        SimpleServiceLocator.enderStorageProxy.openEnderChest(player.field_70170_p, xCoord, yCoord, zCoord, player);
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SlotFinderActivatePacket.class).setTagetPosX(xCoord).setTagetPosY(yCoord).setTagetPosZ(zCoord).setSlot(this.getSlot()).setPacketPos(this), player);
                        return true;
                    }
                    if (block.func_180639_a(player.field_70170_p, blockPos, blockState, player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f)) {
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SlotFinderActivatePacket.class).setTagetPosX(xCoord).setTagetPosY(yCoord).setTagetPosZ(zCoord).setSlot(this.getSlot()).setPacketPos(this), player);
                        return true;
                    }
                }
                return false;
            });
        }
        if (!openedGui) {
            LogisticsPipes.log.warn("Ignored SlotFinderOpenGuiPacket from " + player.toString() + ", because of failing preconditions");
        }
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    @Override
    public ModernPacket template() {
        return new SlotFinderOpenGuiPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.slot);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.slot = input.readInt();
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotFinderOpenGuiPacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

