/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import javax.annotation.Nonnull;
import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class PipeItemsBasicLogistics
extends CoreRoutedPipe {
    private final ModuleItemSink itemSinkModule = new ModuleItemSink();

    public PipeItemsBasicLogistics(Item item) {
        super(new PipeTransportLogistics(true){

            @Override
            public boolean canPipeConnect(TileEntity tile, EnumFacing dir) {
                if (super.canPipeConnect(tile, dir)) {
                    return true;
                }
                if (tile instanceof LogisticsSecurityTileEntity) {
                    EnumFacing ori = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile);
                    return ori != null && ori != EnumFacing.DOWN && ori != EnumFacing.UP;
                }
                if (tile instanceof LogisticsProgramCompilerTileEntity) {
                    EnumFacing ori = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile);
                    return ori != null && ori != EnumFacing.DOWN;
                }
                return false;
            }
        }, item);
        this.itemSinkModule.registerHandler(this, this);
        this.itemSinkModule.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(EnumFacing connection) {
        if (this.isSecurityProvider(connection)) {
            return Textures.LOGISTICSPIPE_SECURITY_TEXTURE;
        }
        return super.getNonRoutedTexture(connection);
    }

    @Override
    public boolean isLockedExit(EnumFacing orientation) {
        if (this.isPowerJunction(orientation) || this.isSecurityProvider(orientation)) {
            return true;
        }
        return super.isLockedExit(orientation);
    }

    private boolean isPowerJunction(EnumFacing ori) {
        TileEntity tilePipe = this.container.getTile(ori);
        if (tilePipe == null || !this.container.canPipeConnect(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof LogisticsPowerJunctionTileEntity;
    }

    private boolean isSecurityProvider(EnumFacing ori) {
        TileEntity tilePipe = this.container.getTile(ori);
        if (tilePipe == null || !this.container.canPipeConnect(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof LogisticsSecurityTileEntity;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public ModuleItemSink getLogisticsModule() {
        return this.itemSinkModule;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void setTile(TileEntity tile) {
        super.setTile(tile);
        this.itemSinkModule.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        if (!this.itemSinkModule.isDefaultRoute()) {
            this.itemSinkModule.collectSpecificInterests(itemidCollection);
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return this.itemSinkModule.isDefaultRoute();
    }
}

