/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCQueued;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.RequestHandler;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;

@CCType(name="LogisticsPipes:Request")
public class PipeItemsRequestLogistics
extends CoreRoutedPipe
implements IRequestItems {
    private final LinkedList<Map<ItemIdentifier, Integer>> _history = new LinkedList();

    public PipeItemsRequestLogistics(Item item) {
        super(item);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_REQUESTER_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public void openGui(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (settings == null || settings.openRequest) {
                this.openGui(entityplayer);
            } else {
                entityplayer.func_145747_a((ITextComponent)new TextComponentString("Permission denied"));
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.getWorld().func_82737_E() % 1200L == 0L) {
            this._history.addLast(SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost()));
            if (this._history.size() > 20) {
                this._history.removeFirst();
            }
        }
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @CCCommand(description="Requests the given ItemIdentifierStack")
    @CCQueued
    public Object[] makeRequest(ItemIdentifierStack stack) throws Exception {
        return this.makeRequest(stack.getItem(), Double.valueOf(stack.getStackSize()), false);
    }

    @CCCommand(description="Requests the given ItemIdentifierStack")
    @CCQueued
    public Object[] makeRequest(ItemIdentifierStack stack, Boolean forceCrafting) throws Exception {
        return this.makeRequest(stack.getItem(), Double.valueOf(stack.getStackSize()), forceCrafting);
    }

    @CCCommand(description="Requests the given ItemIdentifier with the given amount")
    @CCQueued
    public Object[] makeRequest(ItemIdentifier item, Double amount) throws Exception {
        return this.makeRequest(item, amount, false);
    }

    @CCCommand(description="Requests the given ItemIdentifier with the given amount")
    @CCQueued
    public Object[] makeRequest(ItemIdentifier item, Double amount, Boolean forceCrafting) throws Exception {
        if (forceCrafting == null) {
            forceCrafting = false;
        }
        if (item == null) {
            throw new Exception("Invalid ItemIdentifier");
        }
        return RequestHandler.computerRequest(item.makeStack((int)Math.floor(amount)), this, forceCrafting);
    }

    @CCCommand(description="Asks for all available ItemIdentifier inside the Logistics Network")
    @CCQueued
    public List<Pair<ItemIdentifier, Integer>> getAvailableItems() {
        Map<ItemIdentifier, Integer> items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        LinkedList<Pair<ItemIdentifier, Integer>> list = new LinkedList<Pair<ItemIdentifier, Integer>>();
        for (Map.Entry<ItemIdentifier, Integer> item : items.entrySet()) {
            int amount = item.getValue();
            list.add(new Pair<ItemIdentifier, Integer>(item.getKey(), amount));
        }
        return list;
    }

    @CCCommand(description="Asks for all craftable ItemIdentifier inside the Logistics Network")
    @CCQueued
    public List<ItemIdentifier> getCraftableItems() {
        return SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
    }

    @CCCommand(description="Asks for the amount of an ItemIdentifier Id inside the Logistics Network")
    @CCQueued
    public int getItemAmount(ItemIdentifier item) throws Exception {
        Map<ItemIdentifier, Integer> items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        if (item == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        if (items.containsKey(item)) {
            return items.get(item);
        }
        return 0;
    }
}

