/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.pipefxhandlers.EntityModelFX;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.PipeItemsBasicLogistics;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IBounds;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.interfaces.IVec3;
import logisticspipes.proxy.object3d.interfaces.TextureTransformation;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVScale;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.newpipe.GLRenderList;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.RenderEntry;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.textures.Textures;
import logisticspipes.utils.tuples.Quartet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import org.lwjgl.opengl.GL11;

public class LogisticsNewRenderPipe
implements IHighlightPlacementRenderer {
    static Map<EnumFacing, List<IModel3D>> sideNormal = new HashMap<EnumFacing, List<IModel3D>>();
    static Map<EnumFacing, List<IModel3D>> sideBC = new HashMap<EnumFacing, List<IModel3D>>();
    static Map<Edge, IModel3D> edges = new HashMap<Edge, IModel3D>();
    static Map<Corner, List<IModel3D>> corners_M = new HashMap<Corner, List<IModel3D>>();
    static Map<Corner, List<IModel3D>> corners_I3 = new HashMap<Corner, List<IModel3D>>();
    static Map<PipeTurnCorner, IModel3D> corners_I = new HashMap<PipeTurnCorner, IModel3D>();
    static Map<PipeSupport, IModel3D> supports = new HashMap<PipeSupport, IModel3D>();
    static Map<PipeTurnCorner, IModel3D> spacers = new HashMap<PipeTurnCorner, IModel3D>();
    static Map<PipeMount, IModel3D> mounts = new HashMap<PipeMount, IModel3D>();
    static Map<EnumFacing, List<IModel3D>> texturePlate_Inner = new HashMap<EnumFacing, List<IModel3D>>();
    static Map<EnumFacing, List<IModel3D>> texturePlate_Outer = new HashMap<EnumFacing, List<IModel3D>>();
    static Map<EnumFacing, Quartet<List<IModel3D>, List<IModel3D>, List<IModel3D>, List<IModel3D>>> sideTexturePlate = new HashMap<EnumFacing, Quartet<List<IModel3D>, List<IModel3D>, List<IModel3D>, List<IModel3D>>>();
    static Map<PipeMount, List<IModel3D>> textureConnectorPlate = new HashMap<PipeMount, List<IModel3D>>();
    static Map<ScaleObject, IModel3D> scaleMap = new HashMap<ScaleObject, IModel3D>();
    static IModel3D innerTransportBox;
    public static IModel3D highlight;
    private static final List<RenderEntry> pipeFrameRenderList;
    public static TextureTransformation basicPipeTexture;
    public static TextureTransformation inactiveTexture;
    public static TextureTransformation glassCenterTexture;
    public static TextureTransformation innerBoxTexture;
    public static TextureTransformation statusTexture;
    public static TextureTransformation statusBCTexture;
    private ClientConfiguration config = LogisticsPipes.getClientPlayerConfig();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadModels() {
        if (!SimpleServiceLocator.cclProxy.isActivated()) {
            return;
        }
        try {
            String grp;
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/PipeModel_moved.obj"), 7, new LPScale(0.01f));
            ArrayList<IModel3D> highlightList = new ArrayList<IModel3D>();
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                sideNormal.put(enumFacing, new ArrayList());
                grp = "Side_" + LogisticsNewRenderPipe.getDirAsString_Type1(enumFacing);
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp + " ") || ((String)entry.getKey()).endsWith(" " + grp)).forEach(entry -> sideNormal.get(enumFacing).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)))));
                if (sideNormal.get(enumFacing).size() == 4) continue;
                throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + sideNormal.get(enumFacing).size());
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                sideBC.put(enumFacing, new ArrayList());
                grp = "Side_BC_" + LogisticsNewRenderPipe.getDirAsString_Type1(enumFacing);
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp + " ") || ((String)entry.getKey()).endsWith(" " + grp)).forEach(entry -> sideBC.get(enumFacing).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)))));
                if (sideBC.get(enumFacing).size() == 8) continue;
                throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + sideBC.get(enumFacing).size());
            }
            for (Edge edge : Edge.values()) {
                grp = edge.part1 == EnumFacing.UP || edge.part1 == EnumFacing.DOWN ? "Edge_M_" + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part1) + "_" + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part2) : "Edge_M_S_" + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part1) + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part2);
                for (Map.Entry<String, IModel3D> entry2 : pipePartModels.entrySet()) {
                    if (!entry2.getKey().contains(" " + grp + " ") && !entry2.getKey().endsWith(" " + grp)) continue;
                    edges.put(edge, LogisticsNewRenderPipe.compute(entry2.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (edges.get((Object)edge) == null) {
                    throw new RuntimeException("Couldn't load " + edge.name() + " (" + grp + ")");
                }
                highlightList.add(edges.get((Object)edge));
            }
            for (Corner corner : Corner.values()) {
                corners_M.put(corner, new ArrayList());
                grp = "Corner_M_" + corner.ud.s + "_" + corner.ns.s + corner.ew.s;
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp + " ") || ((String)entry.getKey()).endsWith(" " + grp)).forEach(entry -> corners_M.get((Object)corner).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)))));
                if (corners_M.get((Object)corner).size() != 2) {
                    throw new RuntimeException("Couldn't load " + corner.name() + " (" + grp + "). Only loaded " + corners_M.get((Object)corner).size());
                }
                highlightList.addAll((Collection)corners_M.get((Object)corner));
            }
            for (Corner corner : Corner.values()) {
                corners_I3.put(corner, new ArrayList());
                grp = "Corner_I3_" + corner.ud.s + "_" + corner.ns.s + corner.ew.s;
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp + " ") || ((String)entry.getKey()).endsWith(" " + grp)).forEach(entry -> corners_I3.get((Object)corner).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)))));
                if (corners_I3.get((Object)corner).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + corner.name() + " (" + grp + "). Only loaded " + corners_I3.get((Object)corner).size());
            }
            for (PipeSupport pipeSupport : PipeSupport.values()) {
                grp = "Support_" + LogisticsNewRenderPipe.getDirAsString_Type1(pipeSupport.dir) + "_" + pipeSupport.ori.s;
                for (Map.Entry<String, IModel3D> entry2 : pipePartModels.entrySet()) {
                    if (!entry2.getKey().contains(" " + grp + " ") && !entry2.getKey().endsWith(" " + grp)) continue;
                    supports.put(pipeSupport, LogisticsNewRenderPipe.compute(entry2.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (supports.get((Object)pipeSupport) != null) continue;
                throw new RuntimeException("Couldn't load " + pipeSupport.name() + " (" + grp + ")");
            }
            for (PipeTurnCorner pipeTurnCorner : PipeTurnCorner.values()) {
                grp = "Corner_I_" + pipeTurnCorner.corner.ud.s + "_" + pipeTurnCorner.corner.ns.s + pipeTurnCorner.corner.ew.s;
                for (Map.Entry<String, IModel3D> entry2 : pipePartModels.entrySet()) {
                    if (!entry2.getKey().contains(" " + grp)) continue;
                    char c = ' ';
                    if (!entry2.getKey().endsWith(" " + grp)) {
                        c = entry2.getKey().charAt(entry2.getKey().indexOf(" " + grp) + (" " + grp).length());
                    }
                    if (Character.isDigit(c)) {
                        if (c == '2') {
                            if (pipeTurnCorner.turn != Turn.NORTH_SOUTH) {
                                continue;
                            }
                        } else {
                            if (c != 49) throw new UnsupportedOperationException();
                            if (pipeTurnCorner.turn != Turn.EAST_WEST) {
                                continue;
                            }
                        }
                    } else if (pipeTurnCorner.turn != Turn.UP_DOWN) continue;
                    corners_I.put(pipeTurnCorner, LogisticsNewRenderPipe.compute(entry2.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (corners_I.get((Object)pipeTurnCorner) != null) continue;
                throw new RuntimeException("Couldn't load " + pipeTurnCorner.name() + " (" + grp + ")");
            }
            for (PipeTurnCorner pipeTurnCorner : PipeTurnCorner.values()) {
                grp = "Spacer" + pipeTurnCorner.number;
                for (Map.Entry<String, IModel3D> entry2 : pipePartModels.entrySet()) {
                    if (!entry2.getKey().contains(" " + grp + " ") && !entry2.getKey().endsWith(" " + grp)) continue;
                    spacers.put(pipeTurnCorner, LogisticsNewRenderPipe.compute(entry2.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (spacers.get((Object)pipeTurnCorner) != null) continue;
                throw new RuntimeException("Couldn't load " + pipeTurnCorner.name() + " (" + grp + ")");
            }
            for (PipeMount pipeMount : PipeMount.values()) {
                grp = "Mount_" + LogisticsNewRenderPipe.getDirAsString_Type1(pipeMount.dir) + "_" + LogisticsNewRenderPipe.getDirAsString_Type1(pipeMount.side);
                for (Map.Entry<String, IModel3D> entry2 : pipePartModels.entrySet()) {
                    if (!entry2.getKey().contains(" " + grp + " ") && !entry2.getKey().endsWith(" " + grp)) continue;
                    mounts.put(pipeMount, LogisticsNewRenderPipe.compute(entry2.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (mounts.get((Object)pipeMount) != null) continue;
                throw new RuntimeException("Couldn't load " + pipeMount.name() + " (" + grp + ")");
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                texturePlate_Inner.put(enumFacing, new ArrayList());
                grp = "Inner_Plate_" + LogisticsNewRenderPipe.getDirAsString_Type1(enumFacing);
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp)).forEach(entry -> texturePlate_Inner.get(enumFacing).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)))));
                if (texturePlate_Inner.get(enumFacing).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + texturePlate_Inner.get(enumFacing).size());
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                texturePlate_Outer.put(enumFacing, new ArrayList());
                grp = "Texture_Plate_" + LogisticsNewRenderPipe.getDirAsString_Type1(enumFacing);
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp)).forEach(entry -> texturePlate_Outer.get(enumFacing).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)).apply(new LPTranslation(-0.5, -0.5, -0.5)).apply(new LPScale(1.001)).apply(new LPTranslation(0.5, 0.5, 0.5)))));
                if (texturePlate_Outer.get(enumFacing).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + texturePlate_Outer.get(enumFacing).size());
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                sideTexturePlate.put(enumFacing, new Quartet(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()));
                grp = "Texture_Side_" + LogisticsNewRenderPipe.getDirAsString_Type1(enumFacing);
                for (Map.Entry<String, IModel3D> entry2 : pipePartModels.entrySet()) {
                    if (!entry2.getKey().contains(" " + grp)) continue;
                    IModel3D model = LogisticsNewRenderPipe.compute(entry2.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)));
                    double sizeA = model.bounds().max().x() - model.bounds().min().x() + (model.bounds().max().y() - model.bounds().min().y()) + (model.bounds().max().z() - model.bounds().min().z());
                    double dis = Math.pow(model.bounds().min().x() - 0.5, 2.0) + Math.pow(model.bounds().min().y() - 0.5, 2.0) + Math.pow(model.bounds().min().z() - 0.5, 2.0);
                    if (sizeA < 0.5) {
                        if (dis > 0.22 && dis < 0.24 || dis > 0.38 && dis < 0.4) {
                            sideTexturePlate.get(enumFacing).getValue4().add(model);
                            continue;
                        }
                        if (!(dis < 0.2 && dis > 0.18) && (!(dis < 0.36) || !(dis > 0.34))) throw new UnsupportedOperationException("Dis: " + dis);
                        ((List)sideTexturePlate.get(enumFacing).getValue2()).add(model);
                        continue;
                    }
                    if (dis > 0.22 && dis < 0.24 || dis > 0.38 && dis < 0.4) {
                        ((List)sideTexturePlate.get(enumFacing).getValue3()).add(model);
                        continue;
                    }
                    if (!(dis < 0.2 && dis > 0.18) && (!(dis < 0.36) || !(dis > 0.34))) throw new UnsupportedOperationException("Dis: " + dis);
                    ((List)sideTexturePlate.get(enumFacing).getValue1()).add(model);
                }
                if (((List)sideTexturePlate.get(enumFacing).getValue1()).size() != 8) {
                    throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + ((List)sideTexturePlate.get(enumFacing).getValue1()).size());
                }
                if (((List)sideTexturePlate.get(enumFacing).getValue2()).size() != 8) {
                    throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + ((List)sideTexturePlate.get(enumFacing).getValue2()).size());
                }
                if (((List)sideTexturePlate.get(enumFacing).getValue3()).size() != 8) {
                    throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + ((List)sideTexturePlate.get(enumFacing).getValue3()).size());
                }
                if (sideTexturePlate.get(enumFacing).getValue4().size() == 8) continue;
                throw new RuntimeException("Couldn't load " + enumFacing.name() + " (" + grp + "). Only loaded " + sideTexturePlate.get(enumFacing).getValue4().size());
            }
            for (PipeMount pipeMount : PipeMount.values()) {
                textureConnectorPlate.put(pipeMount, new ArrayList());
                grp = "Texture_Connector_" + LogisticsNewRenderPipe.getDirAsString_Type1(pipeMount.dir) + "_" + LogisticsNewRenderPipe.getDirAsString_Type1(pipeMount.side);
                pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(" " + grp + " ") || ((String)entry.getKey()).endsWith(" " + grp)).forEach(entry -> textureConnectorPlate.get((Object)pipeMount).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)))));
                if (textureConnectorPlate.get((Object)pipeMount).size() == 4) continue;
                throw new RuntimeException("Couldn't load " + pipeMount.name() + " (" + grp + "). Only loaded " + textureConnectorPlate.get((Object)pipeMount).size());
            }
            highlight = SimpleServiceLocator.cclProxy.combine(highlightList);
            pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/PipeModel_Transport_Box.obj"), 7, new LPScale(0.01f));
            innerTransportBox = LogisticsNewRenderPipe.compute(pipePartModels.get("InnerTransportBox").backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)).apply(new LPTranslation(-0.5, -0.5, -0.5)).apply(new LPScale(0.99)).apply(new LPTranslation(0.5, 0.5, 0.5)));
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDirAsString_Type1(EnumFacing dir) {
        switch (dir) {
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case EAST: {
                return "E";
            }
            case WEST: {
                return "W";
            }
            case UP: {
                return "U";
            }
            case DOWN: {
                return "D";
            }
        }
        return "UNKNWON";
    }

    public static IModel3D compute(IModel3D m) {
        m.computeNormals();
        return m;
    }

    public static void registerTextures(TextureMap iconRegister) {
        if (basicPipeTexture == null) {
            basicPipeTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel")));
            inactiveTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel-inactive")));
            innerBoxTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/InnerBox")));
            glassCenterTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/Glass_Texture_Center")));
            statusTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel-status")));
            statusBCTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel-status-BC")));
        } else {
            basicPipeTexture.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel")));
            inactiveTexture.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel-inactive")));
            innerBoxTexture.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/InnerBox")));
            glassCenterTexture.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/Glass_Texture_Center")));
            statusTexture.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel-status")));
            statusBCTexture.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/PipeModel-status-BC")));
        }
    }

    public void renderTileEntityAt(LogisticsTileGenericPipe pipeTile, double x, double y, double z, float partialTickTime, double distance) {
        boolean inHand = false;
        if (pipeTile == null) {
            // empty if block
        }
        if (pipeTile.pipe instanceof PipeBlockRequestTable) {
            return;
        }
        if (pipeTile.pipe == null) {
            return;
        }
        PipeRenderState renderState = pipeTile.renderState;
        if (renderState.renderLists != null && renderState.renderLists.values().stream().anyMatch(GLRenderList::isInvalid)) {
            renderState.renderLists = null;
        }
        if (renderState.renderLists == null) {
            renderState.renderLists = new HashMap<ResourceLocation, GLRenderList>();
        }
        if (!(distance > (double)(this.config.getRenderPipeDistance() * this.config.getRenderPipeDistance()))) {
            renderState.forceRenderOldPipe = false;
            boolean recalculateList = LogisticsNewRenderPipe.checkAndCalculateRenderCache(pipeTile);
            LogisticsNewRenderPipe.renderList(x, y, z, renderState.renderLists, renderState.cachedRenderer, recalculateList);
            if (recalculateList) {
                pipeTile.func_145831_w().func_175704_b(pipeTile.func_174877_v(), pipeTile.func_174877_v());
            }
        }
    }

    public static boolean checkAndCalculateRenderCache(LogisticsTileGenericPipe pipeTile) {
        PipeRenderState renderState = pipeTile.renderState;
        if (renderState.cachedRenderIndex != MainProxy.proxy.getRenderIndex()) {
            renderState.clearRenderCaches();
        }
        if (renderState.cachedRenderer == null) {
            ArrayList<RenderEntry> objectsToRender = new ArrayList<RenderEntry>();
            if (pipeTile.pipe != null && pipeTile.pipe.actAsNormalPipe()) {
                LogisticsNewRenderPipe.fillObjectsToRenderList(objectsToRender, pipeTile, renderState);
            }
            if (pipeTile.pipe != null && pipeTile.pipe.getSpecialRenderer() != null) {
                pipeTile.pipe.getSpecialRenderer().renderToList(pipeTile.pipe, objectsToRender);
            }
            renderState.cachedRenderIndex = MainProxy.proxy.getRenderIndex();
            renderState.cachedRenderer = Collections.unmodifiableList(objectsToRender);
            return true;
        }
        return false;
    }

    private static void renderList(double x, double y, double z, Map<ResourceLocation, GLRenderList> renderLists, List<RenderEntry> cachedRenderer, boolean recalculateList) {
        if (renderLists.isEmpty() || !renderLists.values().stream().allMatch(GLRenderList::isFilled) || recalculateList) {
            HashMap sorted2 = new HashMap();
            for (RenderEntry renderEntry : cachedRenderer) {
                if (!sorted2.containsKey(renderEntry.getTexture())) {
                    sorted2.put(renderEntry.getTexture(), new LinkedList());
                }
                ((List)sorted2.get(renderEntry.getTexture())).add(renderEntry);
            }
            for (Map.Entry entry : sorted2.entrySet()) {
                GLRenderList renderList;
                if (((ResourceLocation)entry.getKey()).equals((Object)TextureMap.field_110575_b)) continue;
                if (!renderLists.containsKey(entry.getKey())) {
                    renderLists.put((ResourceLocation)entry.getKey(), SimpleServiceLocator.renderListHandler.getNewRenderList());
                }
                if ((renderList = renderLists.get(entry.getKey())).isFilled() && !recalculateList) continue;
                renderList.startListCompile();
                SimpleServiceLocator.cclProxy.getRenderState().reset();
                SimpleServiceLocator.cclProxy.getRenderState().startDrawing(7, DefaultVertexFormats.field_181703_c);
                for (RenderEntry entry2 : (List)entry.getValue()) {
                    entry2.getModel().render(entry2.getOperations());
                }
                SimpleServiceLocator.cclProxy.getRenderState().draw();
                renderList.stopCompile();
            }
        }
        if (!renderLists.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)0);
            for (Map.Entry<ResourceLocation, GLRenderList> entry : renderLists.entrySet()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(entry.getKey());
                entry.getValue().render();
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void fillObjectsToRenderList(List<RenderEntry> objectsToRender, LogisticsTileGenericPipe pipeTile, PipeRenderState renderState) {
        void var10_25;
        EnumFacing dir;
        int n;
        void var7_10;
        ArrayList<Edge> edgesToRender = new ArrayList<Edge>(Arrays.asList(Edge.values()));
        HashMap<I3DOperation, Integer> connectionAtCorner = new HashMap<I3DOperation, Integer>();
        ArrayList<PipeMount> mountCanidates = new ArrayList<PipeMount>(Arrays.asList(PipeMount.values()));
        int connectionCount = 0;
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            I3DOperation[] texture;
            if (!renderState.pipeConnectionMatrix.isConnected(enumFacing) && !pipeTile.pipe.hasSpecialPipeEndAt(enumFacing)) continue;
            ++connectionCount;
            if (renderState.pipeConnectionMatrix.isTDConnected(enumFacing) || renderState.pipeConnectionMatrix.isBCConnected(enumFacing)) {
                texture = new I3DOperation[]{basicPipeTexture};
                if (renderState.textureMatrix.isRouted()) {
                    texture = renderState.textureMatrix.isRoutedInDir(enumFacing) ? (renderState.textureMatrix.isSubPowerInDir(enumFacing) ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.23f), statusBCTexture)} : new I3DOperation[]{statusBCTexture}) : new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, -0.23f), statusBCTexture)};
                }
                for (IModel3D model2 : sideBC.get(enumFacing)) {
                    objectsToRender.add(new RenderEntry(model2, texture));
                }
            } else if (!pipeTile.pipe.hasSpecialPipeEndAt(enumFacing)) {
                texture = new I3DOperation[]{basicPipeTexture};
                if (renderState.textureMatrix.isRouted()) {
                    texture = renderState.textureMatrix.isRoutedInDir(enumFacing) ? (renderState.textureMatrix.isSubPowerInDir(enumFacing) ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(-0.25f, 0.0f), statusTexture)} : new I3DOperation[]{statusTexture}) : (renderState.textureMatrix.isHasPowerUpgrade() ? (renderState.textureMatrix.getPointedOrientation() == enumFacing ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.25f, 0.0f), statusTexture)} : new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(-0.25f, 0.37f), statusTexture)}) : (renderState.textureMatrix.getPointedOrientation() == enumFacing ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.25f, 0.37f), statusTexture)} : new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.37f), statusTexture)}));
                }
                for (IModel3D model3 : sideNormal.get(enumFacing)) {
                    void var14_45;
                    double bound;
                    ScaleObject key;
                    IModel3D model2;
                    double[] dArray = new double[]{Block.field_185505_j.field_72338_b, Block.field_185505_j.field_72339_c, Block.field_185505_j.field_72340_a, Block.field_185505_j.field_72337_e, Block.field_185505_j.field_72334_f, Block.field_185505_j.field_72336_d};
                    if (pipeTile.func_145831_w() != null) {
                        DoubleCoordinates coords = CoordinateUtils.add(new DoubleCoordinates(pipeTile), enumFacing);
                        Block block = coords.getBlock((IBlockAccess)pipeTile.func_145831_w());
                        AxisAlignedBB bb = block.func_180646_a(coords.getBlockState((IBlockAccess)pipeTile.func_145831_w()), (IBlockAccess)pipeTile.func_145831_w(), coords.getBlockPos());
                        if (bb == null) {
                            bb = Block.field_185505_j;
                        }
                        double[] dArray2 = new double[]{bb.field_72338_b, bb.field_72339_c, bb.field_72340_a, bb.field_72337_e, bb.field_72334_f, bb.field_72336_d};
                        if (SimpleServiceLocator.enderIOProxy.isItemConduit(coords.getTileEntity((IBlockAccess)pipeTile.func_145831_w()), enumFacing.func_176734_d()) || SimpleServiceLocator.enderIOProxy.isFluidConduit(coords.getTileEntity((IBlockAccess)pipeTile.func_145831_w()), enumFacing.func_176734_d())) {
                            double[] dArray3 = new double[]{0.0249, 0.0249, 0.0249, 0.9751, 0.9751, 0.9751};
                        }
                    }
                    if ((model2 = scaleMap.get(key = new ScaleObject(model3, bound = var14_45[enumFacing.ordinal() / 2 + (enumFacing.ordinal() % 2 == 0 ? 3 : 0)]))) == null) {
                        double toAdd;
                        model2 = model3.copy();
                        IVec3 min = model2.bounds().min();
                        model2.apply(new LPTranslation(min).inverse());
                        if (enumFacing.ordinal() % 2 == 1) {
                            toAdd = 1.0 + bound / 0.1875;
                            model2.apply(new LPScale(enumFacing.func_176730_m().func_177958_n() != 0 ? toAdd : 1.0, enumFacing.func_176730_m().func_177956_o() != 0 ? toAdd : 1.0, enumFacing.func_176730_m().func_177952_p() != 0 ? toAdd : 1.0));
                        } else {
                            bound = 1.0 - bound;
                            toAdd = 1.0 + bound / 0.1875;
                            model2.apply(new LPScale(enumFacing.func_176730_m().func_177958_n() != 0 ? toAdd : 1.0, enumFacing.func_176730_m().func_177956_o() != 0 ? toAdd : 1.0, enumFacing.func_176730_m().func_177952_p() != 0 ? toAdd : 1.0));
                            model2.apply(new LPTranslation((double)enumFacing.func_176730_m().func_177958_n() * bound, (double)enumFacing.func_176730_m().func_177956_o() * bound, (double)enumFacing.func_176730_m().func_177952_p() * bound));
                        }
                        model2.apply(new LPTranslation(min));
                        scaleMap.put(key, model2);
                    }
                    objectsToRender.add(new RenderEntry(model2, texture));
                }
            }
            for (I3DOperation i3DOperation : Edge.values()) {
                if (((Edge)((Object)i3DOperation)).part1 != enumFacing && ((Edge)((Object)i3DOperation)).part2 != enumFacing) continue;
                edgesToRender.remove(i3DOperation);
                for (PipeMount mount2 : PipeMount.values()) {
                    if ((mount2.dir != ((Edge)((Object)i3DOperation)).part1 || mount2.side != ((Edge)((Object)i3DOperation)).part2) && (mount2.dir != ((Edge)((Object)i3DOperation)).part2 || mount2.side != ((Edge)((Object)i3DOperation)).part1)) continue;
                    mountCanidates.remove((Object)mount2);
                }
            }
            for (I3DOperation i3DOperation : Corner.values()) {
                if (((Corner)((Object)i3DOperation)).ew.dir != enumFacing && ((Corner)((Object)i3DOperation)).ns.dir != enumFacing && ((Corner)((Object)i3DOperation)).ud.dir != enumFacing) continue;
                if (!connectionAtCorner.containsKey(i3DOperation)) {
                    connectionAtCorner.put(i3DOperation, 1);
                    continue;
                }
                connectionAtCorner.put(i3DOperation, (Integer)connectionAtCorner.get(i3DOperation) + 1);
            }
        }
        block11: for (Corner corner : Corner.values()) {
            int count2;
            Object cornerTexture = basicPipeTexture;
            if (!renderState.textureMatrix.isHasPower() && renderState.textureMatrix.isRouted()) {
                cornerTexture = inactiveTexture;
            } else if (!renderState.textureMatrix.isRouted() && connectionCount > 2) {
                cornerTexture = inactiveTexture;
            }
            int n2 = count2 = connectionAtCorner.containsKey((Object)corner) ? (Integer)connectionAtCorner.get((Object)corner) : 0;
            if (count2 == 0) {
                for (IModel3D iModel3D : corners_M.get((Object)corner)) {
                    objectsToRender.add(new RenderEntry(iModel3D, new I3DOperation[]{cornerTexture}));
                }
                continue;
            }
            if (count2 == 1) {
                for (PipeTurnCorner pipeTurnCorner : PipeTurnCorner.values()) {
                    if (pipeTurnCorner.corner != corner || !renderState.pipeConnectionMatrix.isConnected(pipeTurnCorner.getPointer()) && !pipeTile.pipe.hasSpecialPipeEndAt(pipeTurnCorner.getPointer())) continue;
                    objectsToRender.add(new RenderEntry(spacers.get((Object)pipeTurnCorner), new I3DOperation[]{cornerTexture}));
                    continue block11;
                }
                continue;
            }
            if (count2 == 2) {
                for (PipeTurnCorner pipeTurnCorner : PipeTurnCorner.values()) {
                    if (pipeTurnCorner.corner != corner || renderState.pipeConnectionMatrix.isConnected(pipeTurnCorner.getPointer()) && !pipeTile.pipe.hasSpecialPipeEndAt(pipeTurnCorner.getPointer())) continue;
                    objectsToRender.add(new RenderEntry(corners_I.get((Object)pipeTurnCorner), new I3DOperation[]{cornerTexture}));
                    continue block11;
                }
                continue;
            }
            if (count2 != 3) continue;
            for (IModel3D iModel3D : corners_I3.get((Object)corner)) {
                objectsToRender.add(new RenderEntry(iModel3D, new I3DOperation[]{cornerTexture}));
            }
        }
        edgesToRender.stream().map(edge -> new RenderEntry(edges.get(edge), basicPipeTexture)).forEach(objectsToRender::add);
        boolean bl = false;
        while (var7_10 < 6) {
            EnumFacing dir2 = EnumFacing.func_82600_a((int)var7_10);
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.field_82609_l));
            list.remove(dir2);
            list.remove(dir2.func_176734_d());
            if (renderState.pipeConnectionMatrix.isConnected(dir2) && renderState.pipeConnectionMatrix.isConnected(dir2.func_176734_d())) {
                boolean bl2 = false;
                for (EnumFacing dir22 : list) {
                    if (!renderState.pipeConnectionMatrix.isConnected(dir22)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    switch (dir2) {
                        case DOWN: {
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.EAST_SIDE), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.WEST_SIDE), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.NORTH_SIDE), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.SOUTH_SIDE), basicPipeTexture));
                            break;
                        }
                        case NORTH: {
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.EAST_UP), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.WEST_UP), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.UP_SIDE), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.DOWN_SIDE), basicPipeTexture));
                            break;
                        }
                        case WEST: {
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.UP_UP), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.DOWN_UP), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.NORTH_UP), basicPipeTexture));
                            objectsToRender.add(new RenderEntry(supports.get((Object)PipeSupport.SOUTH_UP), basicPipeTexture));
                            break;
                        }
                    }
                }
            }
            var7_10 += 2;
        }
        boolean[] blArray = new boolean[6];
        if (pipeTile.func_145831_w() != null) {
            void var10_23;
            EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
            n = enumFacingArray.length;
            boolean bl3 = false;
            while (var10_23 < n) {
                dir = enumFacingArray[var10_23];
                DoubleCoordinates pos = CoordinateUtils.add(new DoubleCoordinates(pipeTile), dir);
                Block blockSide = pos.getBlock((IBlockAccess)pipeTile.func_145831_w());
                if (blockSide == null || !blockSide.isSideSolid(pos.getBlockState((IBlockAccess)pipeTile.func_145831_w()), (IBlockAccess)pipeTile.func_145831_w(), pos.getBlockPos(), dir.func_176734_d()) || renderState.pipeConnectionMatrix.isConnected(dir)) {
                    mountCanidates.removeIf(mount -> mount.dir == dir);
                } else {
                    blArray[dir.ordinal()] = true;
                }
                ++var10_23;
            }
            mountCanidates.removeIf(mount -> SimpleServiceLocator.mcmpProxy.hasParts(pipeTile));
        } else {
            mountCanidates.clear();
        }
        if (!mountCanidates.isEmpty()) {
            if (blArray[EnumFacing.DOWN.ordinal()]) {
                LogisticsNewRenderPipe.findOponentOnSameSide(mountCanidates, EnumFacing.DOWN);
            } else if (blArray[EnumFacing.UP.ordinal()]) {
                LogisticsNewRenderPipe.findOponentOnSameSide(mountCanidates, EnumFacing.UP);
            } else {
                LogisticsNewRenderPipe.removeFromSide(mountCanidates, EnumFacing.DOWN);
                LogisticsNewRenderPipe.removeFromSide(mountCanidates, EnumFacing.UP);
                if (mountCanidates.size() > 2) {
                    LogisticsNewRenderPipe.removeIfHasOponentSide(mountCanidates);
                }
                if (mountCanidates.size() > 2) {
                    LogisticsNewRenderPipe.removeIfHasConnectedSide(mountCanidates);
                }
                if (mountCanidates.size() > 2) {
                    LogisticsNewRenderPipe.findOponentOnSameSide(mountCanidates, ((PipeMount)((Object)mountCanidates.get((int)0))).dir);
                }
            }
            if (LogisticsPipes.isDEBUG() && mountCanidates.size() > 2) {
                new RuntimeException("Trying to render " + mountCanidates.size() + " Mounts").printStackTrace();
            }
            mountCanidates.stream().map(mount -> new RenderEntry(mounts.get(mount), basicPipeTexture)).forEach(objectsToRender::add);
        }
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        n = enumFacingArray.length;
        boolean bl4 = false;
        while (var10_25 < n) {
            dir = enumFacingArray[var10_25];
            if (!renderState.pipeConnectionMatrix.isConnected(dir)) {
                for (IModel3D model6 : texturePlate_Outer.get(dir)) {
                    TextureTransformation textureTransformation = Textures.LPnewPipeIconProvider.getIcon(renderState.textureMatrix.getTextureIndex());
                    if (textureTransformation == null) continue;
                    objectsToRender.add(new RenderEntry(model6, new LPUVTransformationList(new LPUVScale(0.75, 0.75), textureTransformation)));
                }
            }
            ++var10_25;
        }
        if (renderState.textureMatrix.isFluid()) {
            void var10_27;
            enumFacingArray = EnumFacing.field_82609_l;
            n = enumFacingArray.length;
            boolean bl5 = false;
            while (var10_27 < n) {
                dir = enumFacingArray[var10_27];
                if (!renderState.pipeConnectionMatrix.isConnected(dir)) {
                    texturePlate_Inner.get(dir).stream().map(model -> new RenderEntry((IModel3D)model, glassCenterTexture)).forEach(objectsToRender::add);
                } else if (!renderState.textureMatrix.isRoutedInDir(dir)) {
                    ((List)sideTexturePlate.get(dir).getValue1()).stream().map(model -> new RenderEntry((IModel3D)model, basicPipeTexture)).forEach(objectsToRender::add);
                }
                ++var10_27;
            }
        }
        SimpleServiceLocator.thermalDynamicsProxy.renderPipeConnections(pipeTile, objectsToRender);
    }

    private static void findOponentOnSameSide(List<PipeMount> mountCanidates, EnumFacing dir) {
        boolean[] sides = new boolean[6];
        Iterator<PipeMount> iter = mountCanidates.iterator();
        while (iter.hasNext()) {
            PipeMount mount = iter.next();
            if (mount.dir != dir) {
                iter.remove();
                continue;
            }
            sides[mount.side.ordinal()] = true;
        }
        if (mountCanidates.size() <= 2) {
            return;
        }
        ArrayList<EnumFacing> keep = new ArrayList<EnumFacing>();
        if (sides[2] && sides[3]) {
            keep.add(EnumFacing.NORTH);
            keep.add(EnumFacing.SOUTH);
        } else if (sides[4] && sides[5]) {
            keep.add(EnumFacing.EAST);
            keep.add(EnumFacing.WEST);
        } else if (sides[0] && sides[1]) {
            keep.add(EnumFacing.UP);
            keep.add(EnumFacing.DOWN);
        }
        iter = mountCanidates.iterator();
        while (iter.hasNext()) {
            PipeMount mount = iter.next();
            if (keep.contains(mount.side)) continue;
            iter.remove();
        }
    }

    private static void removeFromSide(List<PipeMount> mountCanidates, EnumFacing dir) {
        mountCanidates.removeIf(mount -> mount.dir == dir);
    }

    private static void reduceToOnePerSide(List<PipeMount> mountCanidates, EnumFacing dir, EnumFacing pref) {
        boolean found = false;
        for (PipeMount mount : mountCanidates) {
            if (mount.dir != dir || mount.side != pref) continue;
            found = true;
            break;
        }
        if (!found) {
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, dir);
        } else {
            Iterator<PipeMount> iter = mountCanidates.iterator();
            while (iter.hasNext()) {
                PipeMount mount;
                mount = iter.next();
                if (mount.dir != dir || mount.side == pref) continue;
                iter.remove();
            }
        }
    }

    private static void reduceToOnePerSide(List<PipeMount> mountCanidates, EnumFacing dir) {
        boolean found = false;
        Iterator<PipeMount> iter = mountCanidates.iterator();
        while (iter.hasNext()) {
            PipeMount mount = iter.next();
            if (mount.dir != dir) continue;
            if (found) {
                iter.remove();
                continue;
            }
            found = true;
        }
    }

    private static void removeIfHasOponentSide(List<PipeMount> mountCanidates) {
        boolean[] sides = new boolean[6];
        for (PipeMount mount : mountCanidates) {
            sides[mount.dir.ordinal()] = true;
        }
        if (sides[2] && sides[3]) {
            LogisticsNewRenderPipe.removeFromSide(mountCanidates, EnumFacing.EAST);
            LogisticsNewRenderPipe.removeFromSide(mountCanidates, EnumFacing.WEST);
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, EnumFacing.NORTH);
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, EnumFacing.SOUTH);
        } else if (sides[4] && sides[5]) {
            LogisticsNewRenderPipe.removeFromSide(mountCanidates, EnumFacing.NORTH);
            LogisticsNewRenderPipe.removeFromSide(mountCanidates, EnumFacing.SOUTH);
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, EnumFacing.EAST);
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, EnumFacing.WEST);
        }
    }

    private static void removeIfHasConnectedSide(List<PipeMount> mountCanidates) {
        boolean[] sides = new boolean[6];
        for (PipeMount mount : mountCanidates) {
            sides[mount.dir.ordinal()] = true;
        }
        for (int i = 2; i < 6; ++i) {
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            EnumFacing rot = dir.func_176746_e();
            if (!sides[dir.ordinal()] || !sides[rot.ordinal()]) continue;
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, dir, dir.func_176735_f());
            LogisticsNewRenderPipe.reduceToOnePerSide(mountCanidates, rot, rot.func_176746_e());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderDestruction(CoreUnroutedPipe pipe, World world, int x, int y, int z, ParticleManager effectRenderer) {
        if (pipe.container != null && pipe.container.renderState != null && pipe.container.renderState.cachedRenderer != null) {
            for (RenderEntry entry : pipe.container.renderState.cachedRenderer) {
                IModel3D model = entry.getModel().twoFacedCopy();
                IBounds bounds = model.bounds();
                double xMid = (bounds.min().x() + bounds.max().x()) / 2.0;
                double yMid = (bounds.min().y() + bounds.max().y()) / 2.0;
                double zMid = (bounds.min().z() + bounds.max().z()) / 2.0;
                model.apply(new LPTranslation(-xMid, -yMid, -zMid));
                effectRenderer.func_78873_a((Particle)new EntityModelFX(world, (double)x + xMid, (double)y + yMid, (double)z + zMid, model, entry.getOperations(), entry.getTexture()));
            }
        }
    }

    public static void renderBoxWithDir(EnumFacing dir) {
        ArrayList<RenderEntry> objectsToRender = new ArrayList<RenderEntry>();
        ArrayList<Edge> edgesToRender = new ArrayList<Edge>(Arrays.asList(Edge.values()));
        HashMap<Enum, Integer> connectionAtCorner = new HashMap<Enum, Integer>();
        for (Edge edge2 : Edge.values()) {
            if (edge2.part1 != dir && edge2.part2 != dir) continue;
            edgesToRender.remove((Object)edge2);
        }
        for (Enum enum_ : Corner.values()) {
            if (((Corner)enum_).ew.dir != dir && ((Corner)enum_).ns.dir != dir && ((Corner)enum_).ud.dir != dir) continue;
            if (!connectionAtCorner.containsKey(enum_)) {
                connectionAtCorner.put(enum_, 1);
                continue;
            }
            connectionAtCorner.put(enum_, (Integer)connectionAtCorner.get(enum_) + 1);
        }
        block2: for (Enum enum_ : Corner.values()) {
            TextureTransformation cornerTexture = basicPipeTexture;
            int count2 = connectionAtCorner.getOrDefault(enum_, 0);
            if (count2 == 0) {
                corners_M.get(enum_).stream().map(model -> new RenderEntry((IModel3D)model, cornerTexture)).forEach(objectsToRender::add);
                continue;
            }
            if (count2 == 1) {
                for (PipeTurnCorner turn : PipeTurnCorner.values()) {
                    if (turn.corner != enum_ || turn.getPointer() != dir) continue;
                    objectsToRender.add(new RenderEntry(spacers.get((Object)turn), cornerTexture));
                    continue block2;
                }
                continue;
            }
            if (count2 == 2) {
                for (PipeTurnCorner turn : PipeTurnCorner.values()) {
                    if (turn.corner != enum_ || turn.getPointer() != dir) continue;
                    objectsToRender.add(new RenderEntry(corners_I.get((Object)turn), cornerTexture));
                    continue block2;
                }
                continue;
            }
            if (count2 != 3) continue;
            corners_I3.get(enum_).stream().map(model -> new RenderEntry((IModel3D)model, cornerTexture)).forEach(objectsToRender::add);
        }
        edgesToRender.stream().map(edge -> new RenderEntry(edges.get(edge), basicPipeTexture)).forEach(objectsToRender::add);
        for (RenderEntry model2 : objectsToRender) {
            model2.getModel().render(model2.getOperations());
        }
    }

    @Nonnull
    public ArrayList<BakedQuad> getQuadsFromRenderList(List<RenderEntry> renderEntryList, VertexFormat format, boolean skipNonBlockTextures) {
        ArrayList quads = Lists.newArrayList();
        for (RenderEntry model : renderEntryList) {
            ResourceLocation texture = model.getTexture();
            if (texture == null) {
                throw new NullPointerException();
            }
            if (!texture.equals((Object)TextureMap.field_110575_b)) continue;
            quads.addAll(model.getModel().renderToQuads(format, model.getOperations()));
        }
        return quads;
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        highlight.render(LPColourMultiplier.instance(-1));
    }

    public static List<RenderEntry> getBasicPipeFrameRenderList() {
        if (pipeFrameRenderList.isEmpty()) {
            LogisticsTileGenericPipe pipe = new LogisticsTileGenericPipe();
            pipe.pipe = new PipeItemsBasicLogistics(null);
            LogisticsNewRenderPipe.fillObjectsToRenderList(pipeFrameRenderList, pipe, pipe.renderState);
        }
        return pipeFrameRenderList;
    }

    static {
        pipeFrameRenderList = new ArrayList<RenderEntry>();
    }

    private static class ScaleObject {
        private final IModel3D original;
        private final double scale;

        public IModel3D getOriginal() {
            return this.original;
        }

        public double getScale() {
            return this.scale;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScaleObject)) {
                return false;
            }
            ScaleObject other = (ScaleObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IModel3D this$original = this.getOriginal();
            IModel3D other$original = other.getOriginal();
            if (this$original == null ? other$original != null : !this$original.equals(other$original)) {
                return false;
            }
            return Double.compare(this.getScale(), other.getScale()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScaleObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            IModel3D $original = this.getOriginal();
            result2 = result2 * 59 + ($original == null ? 43 : $original.hashCode());
            long $scale = Double.doubleToLongBits(this.getScale());
            result2 = result2 * 59 + (int)($scale >>> 32 ^ $scale);
            return result2;
        }

        public String toString() {
            return "LogisticsNewRenderPipe.ScaleObject(original=" + this.getOriginal() + ", scale=" + this.getScale() + ")";
        }

        public ScaleObject(IModel3D original, double scale) {
            this.original = original;
            this.scale = scale;
        }
    }

    static enum PipeMount {
        UP_NORTH(EnumFacing.UP, EnumFacing.NORTH),
        UP_SOUTH(EnumFacing.UP, EnumFacing.SOUTH),
        UP_EAST(EnumFacing.UP, EnumFacing.EAST),
        UP_WEST(EnumFacing.UP, EnumFacing.WEST),
        DOWN_NORTH(EnumFacing.DOWN, EnumFacing.NORTH),
        DOWN_SOUTH(EnumFacing.DOWN, EnumFacing.SOUTH),
        DOWN_EAST(EnumFacing.DOWN, EnumFacing.EAST),
        DOWN_WEST(EnumFacing.DOWN, EnumFacing.WEST),
        NORTH_UP(EnumFacing.NORTH, EnumFacing.UP),
        NORTH_DOWN(EnumFacing.NORTH, EnumFacing.DOWN),
        NORTH_EAST(EnumFacing.NORTH, EnumFacing.EAST),
        NORTH_WEST(EnumFacing.NORTH, EnumFacing.WEST),
        SOUTH_UP(EnumFacing.SOUTH, EnumFacing.UP),
        SOUTH_DOWN(EnumFacing.SOUTH, EnumFacing.DOWN),
        SOUTH_EAST(EnumFacing.SOUTH, EnumFacing.EAST),
        SOUTH_WEST(EnumFacing.SOUTH, EnumFacing.WEST),
        EAST_UP(EnumFacing.EAST, EnumFacing.UP),
        EAST_DOWN(EnumFacing.EAST, EnumFacing.DOWN),
        EAST_NORTH(EnumFacing.EAST, EnumFacing.NORTH),
        EAST_SOUTH(EnumFacing.EAST, EnumFacing.SOUTH),
        WEST_UP(EnumFacing.WEST, EnumFacing.UP),
        WEST_DOWN(EnumFacing.WEST, EnumFacing.DOWN),
        WEST_NORTH(EnumFacing.WEST, EnumFacing.NORTH),
        WEST_SOUTH(EnumFacing.WEST, EnumFacing.SOUTH);

        EnumFacing dir;
        EnumFacing side;

        private PipeMount(EnumFacing dir, EnumFacing side) {
            this.dir = dir;
            this.side = side;
        }
    }

    static enum PipeSupport {
        UP_UP(EnumFacing.UP, PipeSupportOri.UP_DOWN),
        UP_SIDE(EnumFacing.UP, PipeSupportOri.SIDE),
        DOWN_UP(EnumFacing.DOWN, PipeSupportOri.UP_DOWN),
        DOWN_SIDE(EnumFacing.DOWN, PipeSupportOri.SIDE),
        NORTH_UP(EnumFacing.NORTH, PipeSupportOri.UP_DOWN),
        NORTH_SIDE(EnumFacing.NORTH, PipeSupportOri.SIDE),
        SOUTH_UP(EnumFacing.SOUTH, PipeSupportOri.UP_DOWN),
        SOUTH_SIDE(EnumFacing.SOUTH, PipeSupportOri.SIDE),
        EAST_UP(EnumFacing.EAST, PipeSupportOri.UP_DOWN),
        EAST_SIDE(EnumFacing.EAST, PipeSupportOri.SIDE),
        WEST_UP(EnumFacing.WEST, PipeSupportOri.UP_DOWN),
        WEST_SIDE(EnumFacing.WEST, PipeSupportOri.SIDE);

        final EnumFacing dir;
        final PipeSupportOri ori;

        private PipeSupport(EnumFacing dir, PipeSupportOri ori) {
            this.dir = dir;
            this.ori = ori;
        }
    }

    static enum PipeSupportOri {
        UP_DOWN("U"),
        SIDE("S");

        final String s;

        private PipeSupportOri(String s) {
            this.s = s;
        }
    }

    static enum PipeTurnCorner {
        UP_NORTH_WEST_TURN_NORTH_SOUTH(Corner.UP_NORTH_WEST, Turn.NORTH_SOUTH, 1),
        UP_NORTH_WEST_TURN_EAST_WEST(Corner.UP_NORTH_WEST, Turn.EAST_WEST, 14),
        UP_NORTH_WEST_TURN_UP_DOWN(Corner.UP_NORTH_WEST, Turn.UP_DOWN, 23),
        UP_NORTH_EAST_TURN_NORTH_SOUTH(Corner.UP_NORTH_EAST, Turn.NORTH_SOUTH, 2),
        UP_NORTH_EAST_TURN_EAST_WEST(Corner.UP_NORTH_EAST, Turn.EAST_WEST, 9),
        UP_NORTH_EAST_TURN_UP_DOWN(Corner.UP_NORTH_EAST, Turn.UP_DOWN, 22),
        UP_SOUTH_WEST_TURN_NORTH_SOUTH(Corner.UP_SOUTH_WEST, Turn.NORTH_SOUTH, 6),
        UP_SOUTH_WEST_TURN_EAST_WEST(Corner.UP_SOUTH_WEST, Turn.EAST_WEST, 13),
        UP_SOUTH_WEST_TURN_UP_DOWN(Corner.UP_SOUTH_WEST, Turn.UP_DOWN, 24),
        UP_SOUTH_EAST_TURN_NORTH_SOUTH(Corner.UP_SOUTH_EAST, Turn.NORTH_SOUTH, 5),
        UP_SOUTH_EAST_TURN_EAST_WEST(Corner.UP_SOUTH_EAST, Turn.EAST_WEST, 10),
        UP_SOUTH_EAST_TURN_UP_DOWN(Corner.UP_SOUTH_EAST, Turn.UP_DOWN, 21),
        DOWN_NORTH_WEST_TURN_NORTH_SOUTH(Corner.DOWN_NORTH_WEST, Turn.NORTH_SOUTH, 4),
        DOWN_NORTH_WEST_TURN_EAST_WEST(Corner.DOWN_NORTH_WEST, Turn.EAST_WEST, 15),
        DOWN_NORTH_WEST_TURN_UP_DOWN(Corner.DOWN_NORTH_WEST, Turn.UP_DOWN, 20),
        DOWN_NORTH_EAST_TURN_NORTH_SOUTH(Corner.DOWN_NORTH_EAST, Turn.NORTH_SOUTH, 3),
        DOWN_NORTH_EAST_TURN_EAST_WEST(Corner.DOWN_NORTH_EAST, Turn.EAST_WEST, 12),
        DOWN_NORTH_EAST_TURN_UP_DOWN(Corner.DOWN_NORTH_EAST, Turn.UP_DOWN, 17),
        DOWN_SOUTH_WEST_TURN_NORTH_SOUTH(Corner.DOWN_SOUTH_WEST, Turn.NORTH_SOUTH, 7),
        DOWN_SOUTH_WEST_TURN_EAST_WEST(Corner.DOWN_SOUTH_WEST, Turn.EAST_WEST, 16),
        DOWN_SOUTH_WEST_TURN_UP_DOWN(Corner.DOWN_SOUTH_WEST, Turn.UP_DOWN, 19),
        DOWN_SOUTH_EAST_TURN_NORTH_SOUTH(Corner.DOWN_SOUTH_EAST, Turn.NORTH_SOUTH, 8),
        DOWN_SOUTH_EAST_TURN_EAST_WEST(Corner.DOWN_SOUTH_EAST, Turn.EAST_WEST, 11),
        DOWN_SOUTH_EAST_TURN_UP_DOWN(Corner.DOWN_SOUTH_EAST, Turn.UP_DOWN, 18);

        final Corner corner;
        final Turn turn;
        final int number;

        private PipeTurnCorner(Corner corner, Turn turn, int number) {
            this.corner = corner;
            this.turn = turn;
            this.number = number;
        }

        public EnumFacing getPointer() {
            ArrayList<EnumFacing> canidates = new ArrayList<EnumFacing>();
            canidates.add(this.corner.ew.dir);
            canidates.add(this.corner.ns.dir);
            canidates.add(this.corner.ud.dir);
            if (canidates.contains(this.turn.dir1)) {
                return this.turn.dir1;
            }
            if (canidates.contains(this.turn.dir2)) {
                return this.turn.dir2;
            }
            throw new UnsupportedOperationException(this.name());
        }
    }

    static enum Turn {
        NORTH_SOUTH(EnumFacing.NORTH, EnumFacing.SOUTH),
        EAST_WEST(EnumFacing.EAST, EnumFacing.WEST),
        UP_DOWN(EnumFacing.UP, EnumFacing.DOWN);

        final EnumFacing dir1;
        final EnumFacing dir2;

        private Turn(EnumFacing dir1, EnumFacing dir2) {
            this.dir1 = dir1;
            this.dir2 = dir2;
        }
    }

    static enum Corner {
        UP_NORTH_WEST(UpDown.UP, NorthSouth.NORTH, EastWest.WEST),
        UP_NORTH_EAST(UpDown.UP, NorthSouth.NORTH, EastWest.EAST),
        UP_SOUTH_WEST(UpDown.UP, NorthSouth.SOUTH, EastWest.WEST),
        UP_SOUTH_EAST(UpDown.UP, NorthSouth.SOUTH, EastWest.EAST),
        DOWN_NORTH_WEST(UpDown.DOWN, NorthSouth.NORTH, EastWest.WEST),
        DOWN_NORTH_EAST(UpDown.DOWN, NorthSouth.NORTH, EastWest.EAST),
        DOWN_SOUTH_WEST(UpDown.DOWN, NorthSouth.SOUTH, EastWest.WEST),
        DOWN_SOUTH_EAST(UpDown.DOWN, NorthSouth.SOUTH, EastWest.EAST);

        final UpDown ud;
        final NorthSouth ns;
        final EastWest ew;

        private Corner(UpDown ud, NorthSouth ns, EastWest ew) {
            this.ud = ud;
            this.ns = ns;
            this.ew = ew;
        }
    }

    static enum EastWest {
        EAST("E", EnumFacing.EAST),
        WEST("W", EnumFacing.WEST);

        final String s;
        final EnumFacing dir;

        private EastWest(String s, EnumFacing dir) {
            this.s = s;
            this.dir = dir;
        }
    }

    static enum NorthSouth {
        NORTH("N", EnumFacing.NORTH),
        SOUTH("S", EnumFacing.SOUTH);

        final String s;
        final EnumFacing dir;

        private NorthSouth(String s, EnumFacing dir) {
            this.s = s;
            this.dir = dir;
        }
    }

    static enum UpDown {
        UP("U", EnumFacing.UP),
        DOWN("D", EnumFacing.DOWN);

        final String s;
        final EnumFacing dir;

        private UpDown(String s, EnumFacing dir) {
            this.s = s;
            this.dir = dir;
        }
    }

    static enum Edge {
        Upper_North(EnumFacing.UP, EnumFacing.NORTH),
        Upper_South(EnumFacing.UP, EnumFacing.SOUTH),
        Upper_East(EnumFacing.UP, EnumFacing.EAST),
        Upper_West(EnumFacing.UP, EnumFacing.WEST),
        Lower_North(EnumFacing.DOWN, EnumFacing.NORTH),
        Lower_South(EnumFacing.DOWN, EnumFacing.SOUTH),
        Lower_East(EnumFacing.DOWN, EnumFacing.EAST),
        Lower_West(EnumFacing.DOWN, EnumFacing.WEST),
        Middle_North_West(EnumFacing.NORTH, EnumFacing.WEST),
        Middle_North_East(EnumFacing.NORTH, EnumFacing.EAST),
        Lower_South_East(EnumFacing.SOUTH, EnumFacing.EAST),
        Lower_South_West(EnumFacing.SOUTH, EnumFacing.WEST);

        final EnumFacing part1;
        final EnumFacing part2;

        private Edge(EnumFacing part1, EnumFacing part2) {
            this.part1 = part1;
            this.part2 = part2;
        }
    }
}

