/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe.tube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.interfaces.ITubeRenderOrientation;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.tubes.HSTubeSpeedup;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import net.minecraft.util.ResourceLocation;

public final class SpeedupTubeRenderer
implements ISpecialPipeRenderer,
IHighlightPlacementRenderer {
    public static final SpeedupTubeRenderer instance = new SpeedupTubeRenderer();
    static Map<HSTubeSpeedup.SpeedupDirection, List<IModel3D>> tubeSpeedupBase = new HashMap<HSTubeSpeedup.SpeedupDirection, List<IModel3D>>();
    public static Map<HSTubeSpeedup.SpeedupDirection, IModel3D> tubeSpeedup = new HashMap<HSTubeSpeedup.SpeedupDirection, IModel3D>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/blocks/pipes/HS-Speedup.png");

    private SpeedupTubeRenderer() {
    }

    public static void loadModels() {
        try {
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/HSTube-Speedup_result.obj"), 7, new LPScale(0.01f));
            for (HSTubeSpeedup.SpeedupDirection turn : HSTubeSpeedup.SpeedupDirection.values()) {
                tubeSpeedupBase.put(turn, new ArrayList());
            }
            pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Side ") || ((String)entry.getKey()).contains(" Side ") || ((String)entry.getKey()).endsWith(" Side")).forEach(entry -> {
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.EAST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 0.0)).apply(new LPRotation(-1.5707963267948966, 0, 1, 0))));
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.WEST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 1.0)).apply(new LPRotation(1.5707963267948966, 0, 1, 0))));
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.SOUTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 0.0)).apply(new LPRotation(Math.PI, 0, 1, 0))));
            });
            if (tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).size() != 4) {
                throw new RuntimeException("Couldn't load Tube Side. Only loaded " + tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).size());
            }
            for (HSTubeSpeedup.SpeedupDirection turn : HSTubeSpeedup.SpeedupDirection.values()) {
                tubeSpeedup.put(turn, SimpleServiceLocator.cclProxy.combine((Collection<IModel3D>)tubeSpeedupBase.get(turn)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public List<IModel3D> getModelsWithoutPipe() {
        return tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH);
    }

    @Override
    @Nonnull
    public List<IModel3D> getModelsFromPipe(@Nonnull CoreUnroutedPipe pipe) {
        if (pipe instanceof HSTubeSpeedup && ((HSTubeSpeedup)pipe).getOrientation() != null) {
            ITubeRenderOrientation orientation = ((HSTubeSpeedup)pipe).getOrientation().getRenderOrientation();
            return Objects.requireNonNull(tubeSpeedupBase.get(orientation), "Could not fetch model for HSTubeSpeedup for orientation " + orientation);
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        HSTubeSpeedup.SpeedupDirection speedupDirection = (HSTubeSpeedup.SpeedupDirection)orientation.getRenderOrientation();
        tubeSpeedup.get(speedupDirection).copy().render(LPColourMultiplier.instance(-1));
        LogisticsNewRenderPipe.renderBoxWithDir(((HSTubeSpeedup.SpeedupDirection)orientation.getRenderOrientation()).getDir1());
    }
}

