/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IReqCraftingTemplate;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;

public class DictCraftingTemplate
implements IReqCraftingTemplate {
    protected DictResource _result;
    protected ICraftItems _crafter;
    protected ArrayList<Pair<IResource, IAdditionalTargetInformation>> _required = new ArrayList(9);
    protected ArrayList<ItemIdentifierStack> _byproduct = new ArrayList(9);
    private final int priority;

    public DictCraftingTemplate(DictResource result2, ICraftItems crafter, int priority) {
        this._result = result2;
        this._crafter = crafter;
        this.priority = priority;
    }

    @Override
    public void addRequirement(IResource requirement, IAdditionalTargetInformation info) {
        this._required.add(new Pair<IResource, IAdditionalTargetInformation>(requirement, info));
    }

    @Override
    public void addByproduct(ItemIdentifierStack stack) {
        for (ItemIdentifierStack i : this._byproduct) {
            if (!i.getItem().equals(stack.getItem())) continue;
            i.setStackSize(i.getStackSize() + stack.getStackSize());
            return;
        }
        this._byproduct.add(stack);
    }

    @Override
    public LogisticsPromise generatePromise(int nResultSets) {
        return new LogisticsDictPromise(this._result, this._result.stack.getStackSize() * nResultSets, (IProvideItems)this._crafter, IOrderInfoProvider.ResourceType.CRAFTING);
    }

    @Override
    public ICraftItems getCrafter() {
        return this._crafter;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ICraftingTemplate o) {
        int c = o.comparePriority(this.priority);
        if (c == 0) {
            c = o.compareStack(this._result.stack);
        }
        if (c == 0) {
            c = o.compareCrafter(this._crafter);
        }
        return c;
    }

    @Override
    public int comparePriority(int priority) {
        return priority - this.priority;
    }

    @Override
    public int compareStack(ItemIdentifierStack stack) {
        return stack.compareTo(this._result.stack);
    }

    @Override
    public int compareCrafter(ICraftItems crafter) {
        return crafter.compareTo(this._crafter);
    }

    @Override
    public boolean canCraft(IResource type) {
        return this._result.matches(type, IResource.MatchSettings.NORMAL);
    }

    @Override
    public int getResultStackSize() {
        return this._result.stack.getStackSize();
    }

    @Override
    public IResource getResultItem() {
        return this._result;
    }

    @Override
    public List<IExtraPromise> getByproducts(int workSets) {
        return this._byproduct.stream().map(stack -> new LogisticsExtraPromise(stack.getItem(), stack.getStackSize() * workSets, (IProvideItems)this.getCrafter(), false)).collect(Collectors.toList());
    }

    @Override
    public List<Pair<IResource, IAdditionalTargetInformation>> getComponents(int nCraftingSetsNeeded) {
        ArrayList<Pair<IResource, IAdditionalTargetInformation>> stacks = new ArrayList<Pair<IResource, IAdditionalTargetInformation>>(this._required.size());
        for (Pair<IResource, IAdditionalTargetInformation> stack : this._required) {
            Pair<IResource, IAdditionalTargetInformation> pair = new Pair<IResource, IAdditionalTargetInformation>(stack.getValue1().clone(nCraftingSetsNeeded), stack.getValue2());
            stacks.add(pair);
        }
        return stacks;
    }
}

