/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.channels;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.interfaces.routing.IChannelManagerProvider;
import logisticspipes.routing.channels.ChannelManager;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChannelManagerProvider
implements IChannelManagerProvider {
    private WeakReference<World> worldWeakReference = null;
    private ChannelManager channelManager = null;

    public ChannelManagerProvider() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IChannelManager getChannelManager(@Nonnull World world) {
        if (this.worldWeakReference == null || this.worldWeakReference.get() == null || this.channelManager == null) {
            this.worldWeakReference = new WeakReference<World>(world);
            if (this.channelManager != null) {
                this.channelManager.markDirty();
            }
            this.channelManager = new ChannelManager(world);
        }
        return this.channelManager;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload worldEvent) {
        if (this.worldWeakReference != null && (this.worldWeakReference.get() == null || this.worldWeakReference.get() == worldEvent.getWorld())) {
            this.channelManager = null;
            this.worldWeakReference = null;
        }
    }
}

