/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.EnumSet;
import java.util.Set;
import logisticspipes.LPItems;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.LPFontRenderer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableMenuListEntry;
import network.rs485.logisticspipes.gui.guidebook.DrawableMenuTile;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.util.math.Rectangle;
import network.rs485.markdown.TextFormat;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\rH\u0016J,\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuListEntry;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "linkedPage", "", "pageName", "icon", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "iconScale", "", "iconSize", "", "itemOffset", "itemRect", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "mouseClicked", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "setPos", "x", "y", "Companion", "logisticspipes"})
public final class DrawableMenuListEntry
extends Drawable {
    private final float iconScale;
    private final int iconSize;
    private final Rectangle itemRect;
    private final int itemOffset;
    private final String linkedPage;
    private final String pageName;
    private final String icon;
    @NotNull
    private static final Lazy itemStackRenderer$delegate;
    public static final Companion Companion;

    @Override
    public void mouseClicked(int mouseX, int mouseY, @NotNull Rectangle visibleArea, @NotNull GuiGuideBook.ActionListener guideActionListener) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Intrinsics.checkNotNullParameter(guideActionListener, "guideActionListener");
        guideActionListener.onMenuButtonClick(this.linkedPage);
    }

    @Override
    public void draw(int mouseX, int mouseY, float delta, @NotNull Rectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        boolean hovered = this.isHovering(mouseX, mouseY, visibleArea);
        GuiGuideBook.Companion.drawRectangleTile(this.getAbsoluteBody(), visibleArea, 4.0f, true, hovered, MinecraftColor.WHITE.getColorCode());
        this.itemRect.setPos(this.getLeft() + (float)this.itemOffset, this.getTop() + (float)this.itemOffset);
        if (this.itemRect.intersects(visibleArea)) {
            int textColor = !hovered ? MinecraftColor.WHITE.getColorCode() : (int)0xFFFFFFA0L;
            int textVerticalOffset = (this.getHeight() - GuiGuideBook.Companion.getLpFontRenderer().getFontHeight(1.0f)) / 2;
            LPFontRenderer lPFontRenderer = GuiGuideBook.Companion.getLpFontRenderer();
            float f = this.itemRect.getRight() + (float)this.itemOffset;
            float f2 = this.getTop() + (float)textVerticalOffset;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)TextFormat.Shadow);
            Intrinsics.checkNotNullExpressionValue(enumSet, "EnumSet.of(TextFormat.Shadow)");
            lPFontRenderer.drawString(this.pageName, f, f2, textColor, (Set<? extends TextFormat>)enumSet, 1.0f);
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.icon));
            if (item == null) {
                item = LPItems.blankModule;
            }
            Item item2 = item;
            DrawableMenuTile.Companion.getItemStackRenderer().renderItemInGui(this.itemRect.getLeft(), this.itemRect.getTop(), item2, 5.0f, this.iconScale);
        }
        if (hovered) {
            GuiGuideBook.Companion.drawLinkIndicator(mouseX, mouseY);
        }
    }

    @Override
    public int setPos(int x, int y) {
        this.getRelativeBody$logisticspipes().setPos(x, y);
        this.itemRect.setPos(this.getLeft() + (float)this.itemOffset, this.getTop() + (float)this.itemOffset);
        return super.setPos(x, y);
    }

    public DrawableMenuListEntry(@NotNull String linkedPage, @NotNull String pageName, @NotNull String icon) {
        Intrinsics.checkNotNullParameter(linkedPage, "linkedPage");
        Intrinsics.checkNotNullParameter(pageName, "pageName");
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.linkedPage = linkedPage;
        this.pageName = pageName;
        this.icon = icon;
        this.iconScale = 1.0f;
        this.iconSize = (int)((float)16 * this.iconScale);
        this.itemRect = new Rectangle();
        this.itemOffset = (24 - this.iconSize) / 2;
        this.getRelativeBody$logisticspipes().setSize(4 * this.itemOffset + this.iconSize + GuiGuideBook.Companion.getLpFontRenderer().getStringWidth(this.pageName), 24);
        this.itemRect.setSize(this.iconSize, this.iconSize);
    }

    static {
        Companion = new Companion(null);
        itemStackRenderer$delegate = LazyKt.lazy(Companion.itemStackRenderer.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuListEntry$Companion;", "", "()V", "itemStackRenderer", "Llogisticspipes/utils/item/ItemStackRenderer;", "getItemStackRenderer", "()Llogisticspipes/utils/item/ItemStackRenderer;", "itemStackRenderer$delegate", "Llogisticspipes/kotlin/Lazy;", "logisticspipes"})
    public static final class Companion {
        @NotNull
        public final ItemStackRenderer getItemStackRenderer() {
            Lazy lazy = itemStackRenderer$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (ItemStackRenderer)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

