/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.gui.guidebook.DrawablePage;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.IPageData;
import network.rs485.logisticspipes.gui.guidebook.PageData;
import network.rs485.logisticspipes.guidebook.BookContents;
import network.rs485.logisticspipes.guidebook.PageInfoProvider;
import network.rs485.logisticspipes.util.ColorUtilKt;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.math.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0016J\u0011\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#J\u0006\u0010+\u001a\u00020\u001fJ*\u0010,\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\n\u0010-\u001a\u00060.R\u00020/J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u0000J\u0011\u00102\u001a\u00020!2\u0006\u00103\u001a\u000204H\u0096\u0001J\u000e\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020#J\t\u00107\u001a\u00020)H\u0096\u0001J\u0016\u00108\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020\u0016J\u0011\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020<H\u0096\u0001R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0016X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006="}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/Page;", "Lnetwork/rs485/logisticspipes/gui/guidebook/IPageData;", "data", "Lnetwork/rs485/logisticspipes/gui/guidebook/PageData;", "(Lnetwork/rs485/logisticspipes/gui/guidebook/PageData;)V", "color", "", "getColor", "()Ljava/lang/Integer;", "setColor", "(Ljava/lang/Integer;)V", "drawable", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawablePage;", "infoProvider", "Lnetwork/rs485/logisticspipes/guidebook/PageInfoProvider;", "page", "", "getPage", "()Ljava/lang/String;", "setPage", "(Ljava/lang/String;)V", "progress", "", "getProgress", "()F", "setProgress", "(F)V", "title", "getTitle", "cycleColor", "inverted", "", "draw", "", "visibleArea", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "mouseX", "mouseY", "partialTicks", "fromTag", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "getExtraHeight", "isBookmarkable", "mouseClicked", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "pageEquals", "other", "read", "input", "Lnetwork/rs485/logisticspipes/util/LPDataInput;", "setDrawablesPosition", "area", "toTag", "updateScrollPosition", "currentProgress", "write", "output", "Lnetwork/rs485/logisticspipes/util/LPDataOutput;", "logisticspipes"})
public final class Page
implements IPageData {
    private final PageInfoProvider infoProvider;
    private final DrawablePage drawable;
    private final /* synthetic */ PageData $$delegate_0;

    @NotNull
    public final String getTitle() {
        return this.infoProvider.getMetadata().getTitle();
    }

    public final void updateScrollPosition(@NotNull Rectangle visibleArea, float currentProgress) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.drawable.updateScrollPosition(visibleArea, currentProgress);
    }

    public final int getExtraHeight(@NotNull Rectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        return visibleArea.getRoundedHeight() < this.drawable.getHeight() ? this.drawable.getHeight() - visibleArea.getRoundedHeight() : 0;
    }

    public final void mouseClicked(int mouseX, int mouseY, @NotNull Rectangle visibleArea, @NotNull GuiGuideBook.ActionListener guideActionListener) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
                Intrinsics.checkNotNullParameter(guideActionListener, "guideActionListener");
                Iterable $this$firstOrNull$iv = this.drawable.getVisibleParagraphs(visibleArea);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DrawableParagraph it = (DrawableParagraph)element$iv;
                    boolean bl = false;
                    if (!it.getAbsoluteBody().contains(mouseX, mouseY)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            DrawableParagraph drawableParagraph = v0;
            if (drawableParagraph == null) break block2;
            drawableParagraph.mouseClicked(mouseX, mouseY, visibleArea, guideActionListener);
        }
    }

    public final void setDrawablesPosition(@NotNull Rectangle area) {
        Intrinsics.checkNotNullParameter(area, "area");
        this.drawable.setWidth(area.getRoundedWidth());
        this.drawable.setPos(area.getRoundedX(), area.getRoundedY());
    }

    public final boolean isBookmarkable() {
        return this.infoProvider.getBookmarkable();
    }

    public final boolean pageEquals(@NotNull Page other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual(this.getPage(), other.getPage());
    }

    public final int cycleColor(boolean inverted) {
        Integer n = this.getColor();
        int n2 = ColorUtilKt.cycleMinecraftColorId(n != null ? n : 0, inverted);
        boolean bl = false;
        boolean bl2 = false;
        int it = n2;
        boolean bl3 = false;
        this.setColor(it);
        return n2;
    }

    public static /* synthetic */ int cycleColor$default(Page page, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return page.cycleColor(bl);
    }

    public final void draw(@NotNull Rectangle visibleArea, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.drawable.preRender(mouseX, mouseY, visibleArea);
        this.drawable.draw(mouseX, mouseY, partialTicks, visibleArea);
    }

    public Page(@NotNull PageData data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.$$delegate_0 = data;
        this.infoProvider = BookContents.INSTANCE.get(this.getPage());
        this.drawable = BookContents.INSTANCE.getDrawablePage(this.getPage());
    }

    @Override
    @Nullable
    public Integer getColor() {
        return this.$$delegate_0.getColor();
    }

    @Override
    public void setColor(@Nullable Integer n) {
        this.$$delegate_0.setColor(n);
    }

    @Override
    @NotNull
    public String getPage() {
        return this.$$delegate_0.getPage();
    }

    @Override
    public void setPage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.$$delegate_0.setPage(string);
    }

    @Override
    public float getProgress() {
        return this.$$delegate_0.getProgress();
    }

    @Override
    public void setProgress(float f) {
        this.$$delegate_0.setProgress(f);
    }

    @Override
    public void fromTag(@NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.$$delegate_0.fromTag(tag);
    }

    @Override
    public void read(@NotNull LPDataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.$$delegate_0.read(input);
    }

    @Override
    @NotNull
    public NBTTagCompound toTag() {
        return this.$$delegate_0.toTag();
    }

    @Override
    public void write(@NotNull LPDataOutput output) {
        Intrinsics.checkNotNullParameter(output, "output");
        this.$$delegate_0.write(output);
    }
}

