/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.blocks.ContainerMinecoprocessor;
import net.torocraft.minecoprocessors.blocks.TileEntityMinecoprocessor;
import net.torocraft.minecoprocessors.gui.ScaledGuiButton;
import net.torocraft.minecoprocessors.network.MessageEnableGuiUpdates;
import net.torocraft.minecoprocessors.network.MessageProcessorAction;
import net.torocraft.minecoprocessors.processor.Processor;
import net.torocraft.minecoprocessors.processor.Register;
import net.torocraft.minecoprocessors.util.BookCreator;
import net.torocraft.minecoprocessors.util.InstructionUtil;

public class GuiMinecoprocessor
extends GuiContainer {
    private static final ResourceLocation TEXTURES = new ResourceLocation("minecoprocessors", "textures/gui/minecoprocessor.png");
    private final IInventory playerInventory;
    private final TileEntityMinecoprocessor minecoprocessor;
    private final List<String> hoveredFeature = new ArrayList<String>(5);
    private GuiButton buttonReset;
    private GuiButton buttonPause;
    private GuiButton buttonStep;
    private GuiButton buttonHelp;
    private Processor processor;
    private byte[] registers = new byte[Register.values().length];
    private byte faultCode = (byte)-1;
    public static GuiMinecoprocessor INSTANCE;

    public BlockPos getPos() {
        return this.minecoprocessor.func_174877_v();
    }

    public GuiMinecoprocessor(IInventory playerInv, TileEntityMinecoprocessor te) {
        super((Container)new ContainerMinecoprocessor(playerInv, te));
        this.playerInventory = playerInv;
        this.minecoprocessor = te;
        INSTANCE = this;
        Minecoprocessors.NETWORK.sendToServer((IMessage)new MessageEnableGuiUpdates(this.minecoprocessor.func_174877_v(), true));
    }

    public void updateData(NBTTagCompound processorData, String name) {
        if (this.processor == null) {
            this.processor = new Processor();
        }
        this.processor.readFromNBT(processorData);
        this.minecoprocessor.setName(I18n.func_135052_a((String)name, (Object[])new Object[0]));
        this.registers = this.processor.getRegisters();
        this.faultCode = this.processor.getFaultCode();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Minecoprocessors.NETWORK.sendToServer((IMessage)new MessageEnableGuiUpdates(this.minecoprocessor.func_174877_v(), false));
        INSTANCE = null;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.hoveredFeature.clear();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        int scale = 2;
        mouseX = (mouseX - this.field_147003_i) * scale;
        mouseY = (mouseY - this.field_147009_r) * scale;
        int y = 50;
        this.drawRegister(Register.A, 260, y, mouseX, mouseY);
        this.drawRegister(Register.B, 278, y, mouseX, mouseY);
        this.drawRegister(Register.C, 296, y, mouseX, mouseY);
        this.drawRegister(Register.D, 314, y, mouseX, mouseY);
        y = 82;
        this.drawFlag("Z", this.processor == null ? null : Boolean.valueOf(this.processor.isZero()), 260, y, mouseX, mouseY);
        this.drawFlag("C", this.processor == null ? null : Boolean.valueOf(this.processor.isCarry() || this.processor.isOverflow()), 278, y, mouseX, mouseY);
        this.drawFlag("F", this.processor == null ? null : Boolean.valueOf(this.processor.isFault()), 296, y, 0xFF0000, mouseX, mouseY);
        this.drawFlag("S", this.processor == null ? null : Boolean.valueOf(this.processor.isWait()), 314, y, 65280, mouseX, mouseY);
        y = 114;
        boolean mouseIsOver = this.drawLabeledShort("IP", this.processor == null ? null : Short.valueOf(this.processor.getIp()), 256, y, mouseX, mouseY);
        if (mouseIsOver) {
            this.hoveredFeature.add("Instruction Pointer");
        }
        this.drawRegister(Register.ADC, 284, y, mouseX, mouseY);
        this.drawRegister(Register.PORTS, 316, y, mouseX, mouseY);
        this.drawPortRegister(Register.PF, 176, 47, mouseX, mouseY);
        this.drawPortRegister(Register.PR, 216, 86, mouseX, mouseY);
        this.drawPortRegister(Register.PL, 137, 86, mouseX, mouseY);
        this.drawPortRegister(Register.PB, 176, 125, mouseX, mouseY);
        this.drawCode();
        GlStateManager.func_179121_F();
        this.drawGuiTitle();
        this.drawInventoryTitle();
        String pauseText = "gui.button.sleep";
        if (this.processor == null || this.processor.isWait()) {
            pauseText = "gui.button.wake";
        }
        this.buttonPause.field_146126_j = I18n.func_135052_a((String)pauseText, (Object[])new Object[0]);
        this.buttonStep.field_146124_l = this.processor != null && this.processor.isWait();
    }

    private void drawPortRegister(Register register, int x, int y, int mouseX, int mouseY) {
        byte value = this.registers[register.ordinal()];
        boolean mouseIsOver = this.centered(GuiMinecoprocessor.toHex(value), x, y, mouseX, mouseY);
        if (mouseIsOver) {
            int portIndex = register.ordinal() - Register.PF.ordinal();
            byte ports = this.registers[Register.PORTS.ordinal()];
            byte adc = this.registers[Register.ADC.ordinal()];
            switch (register) {
                case PF: {
                    this.hoveredFeature.add("Front Port - PF");
                    break;
                }
                case PB: {
                    this.hoveredFeature.add("Back Port - PB");
                    break;
                }
                case PL: {
                    this.hoveredFeature.add("Left Port - PL");
                    break;
                }
                case PR: {
                    this.hoveredFeature.add("Right Port - PR");
                }
            }
            if (TileEntityMinecoprocessor.isInOutputMode(ports, portIndex)) {
                this.hoveredFeature.add("Output Port");
            } else if (TileEntityMinecoprocessor.isInInputMode(ports, portIndex)) {
                this.hoveredFeature.add("Input Port");
            } else if (TileEntityMinecoprocessor.isInResetMode(ports, portIndex)) {
                this.hoveredFeature.add("Reset Port");
            }
            if (TileEntityMinecoprocessor.isADCMode(adc, portIndex)) {
                this.hoveredFeature.add("Analog Mode");
            } else {
                this.hoveredFeature.add("Digital Mode");
            }
            this.hoveredFeature.add(String.format("0x%s %sb %s", GuiMinecoprocessor.toHex(value), GuiMinecoprocessor.toBinary(value), Integer.toString(value, 10)));
        }
    }

    private void drawCode() {
        int x = 22;
        int y = 50;
        String label = "NEXT";
        byte[] a = null;
        if (this.processor != null) {
            try {
                short ip = this.processor.getIp();
                List<byte[]> program = this.processor.getProgram();
                if (ip < program.size()) {
                    a = program.get(ip);
                }
            }
            catch (Exception e) {
                Minecoprocessors.proxy.handleUnexpectedException(e);
            }
        }
        int color = 0xFFFFFF;
        String value = "";
        if (a != null) {
            value = InstructionUtil.compileLine(a, this.processor.getLabels(), (short)-1);
        }
        if (value.isEmpty() && this.processor != null && this.processor.getError() != null) {
            value = this.processor.getError();
            color = 0xFF0000;
        }
        this.field_146289_q.func_78276_b(label, x - 4, y - 14, 0x404040);
        this.field_146289_q.func_78276_b(value, x, y, color);
    }

    private void drawRegister(Register register, int x, int y, int mouseX, int mouseY) {
        byte value;
        String label = register.toString();
        boolean mouseIsOver = this.drawLabeledValue(label, GuiMinecoprocessor.toHex(value = this.registers[register.ordinal()]), x, y, null, mouseX, mouseY);
        if (mouseIsOver) {
            this.hoveredFeature.add(label + " Register");
            if (Register.PORTS.equals((Object)register)) {
                this.hoveredFeature.add("I/O port direction");
            } else if (Register.ADC.equals((Object)register)) {
                this.hoveredFeature.add("ADC/DAC switch");
            } else {
                this.hoveredFeature.add("General Purpose");
            }
            this.hoveredFeature.add(String.format("0x%s %sb %s", GuiMinecoprocessor.toHex(value), GuiMinecoprocessor.toBinary(value), Integer.toString(value, 10)));
        }
    }

    public static String toBinary(Byte b) {
        if (b == null) {
            return null;
        }
        return GuiMinecoprocessor.maxLength(GuiMinecoprocessor.leftPad(Integer.toBinaryString(b.byteValue()), 8), 8);
    }

    private static String maxLength(String s, int l) {
        if (s.length() > l) {
            return s.substring(s.length() - l, s.length());
        }
        return s;
    }

    public static String toHex(Byte b) {
        if (b == null) {
            return null;
        }
        String s = Integer.toHexString(b.byteValue());
        if (s.length() > 2) {
            return s.substring(s.length() - 2, s.length());
        }
        return GuiMinecoprocessor.leftPad(s, 2);
    }

    public static String leftPad(String str, int size) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < pads; ++i) {
            buf.append("0");
        }
        buf.append(str);
        return buf.toString();
    }

    private static String toHex(Short b) {
        if (b == null) {
            return null;
        }
        String s = Integer.toHexString(b.shortValue());
        if (s.length() > 4) {
            return s.substring(s.length() - 4, s.length());
        }
        return GuiMinecoprocessor.leftPad(s, 4);
    }

    private void drawFlag(String label, Boolean flag, int x, int y, int mouseX, int mouseY) {
        this.drawFlag(label, flag, x, y, null, mouseX, mouseY);
    }

    private void drawFlag(String label, Boolean flag, int x, int y, Integer flashColor, int mouseX, int mouseY) {
        boolean mouseIsOver;
        if (flag == null) {
            flag = false;
        }
        if (mouseIsOver = this.drawLabeledValue(label, flag != false ? "1" : "0", x, y, flag != false ? flashColor : null, mouseX, mouseY)) {
            switch (label) {
                case "Z": {
                    this.hoveredFeature.add("Zero Flag");
                    break;
                }
                case "C": {
                    this.hoveredFeature.add("Carry Flag");
                    break;
                }
                case "F": {
                    this.hoveredFeature.add("Fault Indicator");
                    this.hoveredFeature.add("STATUS 0x" + GuiMinecoprocessor.toHex(this.faultCode).toUpperCase());
                    break;
                }
                case "S": {
                    this.hoveredFeature.add("Sleep Indicator");
                }
            }
            this.hoveredFeature.add(Boolean.toString(flag).toUpperCase());
        }
    }

    private void drawLabeledByte(String label, Byte b, int x, int y, int mouseX, int mouseY) {
        this.drawLabeledValue(label, GuiMinecoprocessor.toHex(b), x, y, null, mouseX, mouseY);
    }

    private boolean drawLabeledShort(String label, Short b, int x, int y, int mouseX, int mouseY) {
        return this.drawLabeledValue(label, GuiMinecoprocessor.toHex(b), x, y, null, mouseX, mouseY);
    }

    private boolean drawLabeledValue(String label, String value, int x, int y, Integer flashColor, int mouseX, int mouseY) {
        int wMax;
        int wLabel = this.field_146289_q.func_78256_a(label) / 2;
        int wValue = 0;
        if (value != null) {
            wValue = this.field_146289_q.func_78256_a(value) / 2;
        }
        int color = 0xFFFFFF;
        if (flashColor != null && this.minecoprocessor.func_145831_w().func_82737_E() / 10L % 2L == 0L) {
            color = flashColor;
        }
        this.field_146289_q.func_78276_b(label, x - wLabel, y - 14, 0x404040);
        if (value != null) {
            this.field_146289_q.func_78276_b(value, x - wValue, y, color);
        }
        boolean mouseIsOver = mouseX > x - (wMax = Math.max(wLabel, wValue)) && mouseX < x + wMax;
        mouseIsOver = mouseIsOver && mouseY > y - 14 && mouseY < y + 14;
        return mouseIsOver;
    }

    private boolean centered(String s, float x, float y, int mouseX, int mouseY) {
        int hWidth = this.field_146289_q.func_78256_a(s) / 2;
        int hHeight = this.field_146289_q.field_78288_b / 2;
        int xs = (int)x - hWidth;
        int ys = (int)y - hHeight;
        this.field_146289_q.func_78276_b(s, xs, ys, 0xFFFFFF);
        boolean mouseIsOver = (float)mouseX > x - (float)hWidth && (float)mouseX < x + (float)hWidth;
        mouseIsOver = mouseIsOver && (float)mouseY > y - (float)hHeight - 2.0f && (float)mouseY < y + (float)hHeight + 2.0f;
        return mouseIsOver;
    }

    private void drawInventoryTitle() {
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    private void drawGuiTitle() {
        String s = this.minecoprocessor.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.renderFeatureToolTip(mouseX, mouseY);
    }

    private void renderFeatureToolTip(int x, int y) {
        if (this.hoveredFeature.size() == 0) {
            return;
        }
        this.drawHoveringText(this.hoveredFeature, x, y, this.field_146289_q);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.drawButtons();
    }

    private void drawButtons() {
        int buttonId = 0;
        int x = 8 + this.field_147003_i;
        int y = 34 + this.field_147009_r;
        int buttonWidth = 49;
        int buttonHeight = 10;
        this.buttonReset = new ScaledGuiButton(buttonId++, x, y, buttonWidth, buttonHeight, I18n.func_135052_a((String)"gui.button.reset", (Object[])new Object[0]));
        this.buttonPause = new ScaledGuiButton(buttonId++, x, y + 11, buttonWidth, buttonHeight, I18n.func_135052_a((String)"gui.button.sleep", (Object[])new Object[0]));
        this.buttonStep = new ScaledGuiButton(buttonId++, x, y + 22, buttonWidth, buttonHeight, I18n.func_135052_a((String)"gui.button.step", (Object[])new Object[0]));
        this.buttonHelp = new ScaledGuiButton(buttonId++, this.field_147003_i + 133, this.field_147009_r + 66, 35, buttonHeight, I18n.func_135052_a((String)"gui.button.help", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonReset);
        this.field_146292_n.add(this.buttonStep);
        this.field_146292_n.add(this.buttonPause);
        this.field_146292_n.add(this.buttonHelp);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.buttonReset) {
            Minecoprocessors.NETWORK.sendToServer((IMessage)new MessageProcessorAction(this.minecoprocessor.func_174877_v(), MessageProcessorAction.Action.RESET));
        }
        if (button == this.buttonPause) {
            Minecoprocessors.NETWORK.sendToServer((IMessage)new MessageProcessorAction(this.minecoprocessor.func_174877_v(), MessageProcessorAction.Action.PAUSE));
        }
        if (button == this.buttonStep) {
            Minecoprocessors.NETWORK.sendToServer((IMessage)new MessageProcessorAction(this.minecoprocessor.func_174877_v(), MessageProcessorAction.Action.STEP));
        }
        if (button == this.buttonHelp) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenBook((EntityPlayer)this.field_146297_k.field_71439_g, BookCreator.manual, false));
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i1;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = this.minecoprocessor.func_174887_a_(1);
        int l = MathHelper.func_76125_a((int)((18 * k + 20 - 1) / 20), (int)0, (int)18);
        if (l > 0) {
            this.func_73729_b(i + 60, j + 44, 176, 29, l, 4);
        }
        if ((i1 = this.minecoprocessor.func_174887_a_(0)) > 0) {
            int j1 = (int)(28.0f * (1.0f - (float)i1 / 400.0f));
            if (j1 > 0) {
                this.func_73729_b(i + 97, j + 16, 176, 0, 9, j1);
            }
            if ((j1 = 0) > 0) {
                this.func_73729_b(i + 63, j + 14 + 29 - j1, 185, 29 - j1, 12, j1);
            }
        }
    }
}

