/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.blocks.BlockMinecoprocessor;

@Mod.EventBusSubscriber
public final class ItemBookCode
extends ItemBook {
    public static final Pattern PATTERN_LINES = Pattern.compile("\r?\n");
    public static final int MAX_LINES_PER_PAGE = 20;
    public static final String NAME = "book_code";
    private static final ResourceLocation REGISTRY_NAME = new ResourceLocation("minecoprocessors", "book_code");
    public static final ItemBookCode INSTANCE = new ItemBookCode();

    public static boolean isBookCode(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == INSTANCE;
    }

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
        OreDictionary.registerOre((String)"book", (Item)INSTANCE);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)INSTANCE, (int)0, (ModelResourceLocation)new ModelResourceLocation(REGISTRY_NAME, "inventory"));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        NonNullList lst = NonNullList.func_191196_a();
        lst.add((Object)Ingredient.func_193367_a((Item)Items.field_151099_bA));
        lst.add((Object)Ingredient.func_193367_a((Item)BlockMinecoprocessor.ITEM_INSTANCE));
        event.getRegistry().register(new ShapelessRecipes("", new ItemStack((Item)INSTANCE), lst){

            public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
                NonNullList l = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < l.size(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack.func_77973_b() != BlockMinecoprocessor.ITEM_INSTANCE) continue;
                    ItemStack returnStack = stack.func_77946_l();
                    returnStack.func_190920_e(1);
                    l.set(i, (Object)returnStack);
                    return l;
                }
                throw new RuntimeException("Item to return not found in inventory");
            }
        }.setRegistryName(REGISTRY_NAME));
    }

    protected ItemBookCode() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78028_d);
        this.func_77655_b(NAME);
        this.setRegistryName(REGISTRY_NAME);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)Minecoprocessors.INSTANCE, 1, world, 0, 0, 0);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Minecoprocessors.proxy.i18nFormat("item.book_code.tooltip", new Object[0]));
    }

    public static class Data {
        private static final String TAG_PAGES = "pages";
        private static final String TAG_SELECTED = "selected";
        private final List<List<String>> pages = new ArrayList<List<String>>();
        private int selectedPage = 0;

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public void setSelectedPage(int index) {
            this.selectedPage = index;
            this.validateSelectedPage();
        }

        public int getPageCount() {
            return this.pages.size();
        }

        public List<String> getPage(int index) {
            return Collections.unmodifiableList(this.pages.get(index));
        }

        public void addPage() {
            this.pages.add(Collections.singletonList(""));
            this.setSelectedPage(this.pages.size() - 1);
        }

        public void setPage(int page, List<String> code) {
            this.pages.set(page, new ArrayList<String>(code));
        }

        public void removePage(int index) {
            this.pages.remove(index);
            this.validateSelectedPage();
        }

        public List<List<String>> getProgram() {
            return Collections.unmodifiableList(this.pages);
        }

        public List<String> getContinuousProgram() {
            ArrayList<String> program = new ArrayList<String>();
            for (int i = 0; i < this.pages.size(); ++i) {
                program.addAll(this.getPage(i));
            }
            return program;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.pages.clear();
            NBTTagList pagesNbt = nbt.func_150295_c(TAG_PAGES, 8);
            for (int index = 0; index < pagesNbt.func_74745_c(); ++index) {
                this.pages.add(Arrays.asList(PATTERN_LINES.split(pagesNbt.func_150307_f(index))));
            }
            this.selectedPage = nbt.func_74762_e(TAG_SELECTED);
            this.validateSelectedPage();
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagList pagesNbt = new NBTTagList();
            int removed = 0;
            for (int index = 0; index < this.pages.size(); ++index) {
                List<String> program = this.pages.get(index);
                if (program.size() > 1 || program.get(0).length() > 0) {
                    pagesNbt.func_74742_a((NBTBase)new NBTTagString(String.join((CharSequence)"\n", program)));
                    continue;
                }
                if (index >= this.selectedPage) continue;
                ++removed;
            }
            nbt.func_74782_a(TAG_PAGES, (NBTBase)pagesNbt);
            nbt.func_74768_a(TAG_SELECTED, this.selectedPage - removed);
        }

        private void validateSelectedPage() {
            this.selectedPage = Math.max(0, Math.min(this.pages.size() - 1, this.selectedPage));
        }

        private boolean areAllPagesEqual(List<List<String>> newPages, int startPage) {
            for (int offset = 0; offset < newPages.size(); ++offset) {
                List<String> want;
                List<String> have = this.pages.get(startPage + offset);
                if (Objects.equals(have, want = newPages.get(offset))) continue;
                return false;
            }
            return true;
        }

        public static Data loadFromNBT(@Nullable NBTTagCompound nbt) {
            Data data = new Data();
            if (nbt != null) {
                data.readFromNBT(nbt);
            }
            return data;
        }

        public static Data loadFromStack(ItemStack stack) {
            return Data.loadFromNBT(stack.func_77978_p());
        }

        public static void saveToStack(ItemStack stack, Data data) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            data.writeToNBT(nbt);
        }
    }
}

