/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.network;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMessageHandler<T extends IMessage>
implements IMessageHandler<T, IMessage> {
    @Nullable
    public IMessage onMessage(T message, MessageContext context) {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread(context.netHandler);
        if (thread.func_152345_ab()) {
            this.onMessageSynchronized(message, context);
        } else {
            thread.func_152344_a(() -> this.onMessageSynchronized(message, context));
        }
        return null;
    }

    protected abstract void onMessageSynchronized(T var1, MessageContext var2);

    @Nullable
    protected static World getWorld(int dimension, MessageContext context) {
        switch (context.side) {
            case CLIENT: {
                return AbstractMessageHandler.getWorldClient(dimension);
            }
            case SERVER: {
                return AbstractMessageHandler.getWorldServer(dimension);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    private static World getWorldClient(int dimension) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world == null) {
            return null;
        }
        if (world.field_73011_w.getDimension() != dimension) {
            return null;
        }
        return world;
    }

    @Nullable
    private static World getWorldServer(int dimension) {
        return DimensionManager.getWorld((int)dimension);
    }
}

