/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.items.ItemBookCode;
import net.torocraft.minecoprocessors.network.AbstractMessageHandler;

public final class MessageBookCodeData
implements IMessage {
    private NBTTagCompound nbt;

    public static void init(int packetId) {
        Minecoprocessors.NETWORK.registerMessage(Handler.class, MessageBookCodeData.class, packetId, Side.SERVER);
    }

    public MessageBookCodeData(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public MessageBookCodeData() {
    }

    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this.nbt = buffer.func_150793_b();
        }
        catch (IOException e) {
            Minecoprocessors.proxy.logger.warn("Invalid packet received.", (Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_150786_a(this.nbt);
    }

    public static final class Handler
    extends AbstractMessageHandler<MessageBookCodeData> {
        @Override
        protected void onMessageSynchronized(MessageBookCodeData message, MessageContext context) {
            ItemStack stack;
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            if (player != null && ItemBookCode.isBookCode(stack = player.func_184586_b(EnumHand.MAIN_HAND))) {
                ItemBookCode.Data data = ItemBookCode.Data.loadFromNBT(message.getNbt());
                ItemBookCode.Data.saveToStack(stack, data);
            }
        }
    }
}

