/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.blocks.TileEntityMinecoprocessor;

public class MessageEnableGuiUpdates
implements IMessage {
    public BlockPos pos;
    public Boolean enable;

    public static void init(int packetId) {
        Minecoprocessors.NETWORK.registerMessage(Handler.class, MessageEnableGuiUpdates.class, packetId, Side.SERVER);
    }

    public MessageEnableGuiUpdates() {
    }

    public MessageEnableGuiUpdates(BlockPos controlBlockPos, Boolean enable) {
        this.pos = controlBlockPos;
        this.enable = enable;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.enable = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.enable.booleanValue());
    }

    private static class Worker
    implements Runnable {
        private final EntityPlayerMP player;
        private final MessageEnableGuiUpdates message;

        public Worker(EntityPlayerMP player, MessageEnableGuiUpdates message) {
            this.player = player;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                TileEntityMinecoprocessor mp = (TileEntityMinecoprocessor)this.player.field_70170_p.func_175625_s(this.message.pos);
                mp.enablePlayerGuiUpdates(this.player, this.message.enable);
            }
            catch (Exception e) {
                Minecoprocessors.proxy.handleUnexpectedException(e);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageEnableGuiUpdates, IMessage> {
        public IMessage onMessage(MessageEnableGuiUpdates message, MessageContext ctx) {
            if (message.pos == null) {
                return null;
            }
            EntityPlayerMP payer = ctx.getServerHandler().field_147369_b;
            payer.func_71121_q().func_152344_a((Runnable)new Worker(payer, message));
            return null;
        }
    }
}

