/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.blocks.TileEntityMinecoprocessor;

public class MessageProcessorAction
implements IMessage {
    public Action action;
    public BlockPos pos;

    public static void init(int packetId) {
        Minecoprocessors.NETWORK.registerMessage(Handler.class, MessageProcessorAction.class, packetId, Side.SERVER);
    }

    public MessageProcessorAction() {
    }

    public MessageProcessorAction(BlockPos pos, Action action) {
        this.action = action;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeLong(this.pos.func_177986_g());
    }

    private static class Worker
    implements Runnable {
        private final EntityPlayerMP player;
        private final MessageProcessorAction message;

        public Worker(EntityPlayerMP player, MessageProcessorAction message) {
            this.player = player;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                TileEntityMinecoprocessor mp = (TileEntityMinecoprocessor)this.player.field_70170_p.func_175625_s(this.message.pos);
                switch (this.message.action) {
                    case PAUSE: {
                        mp.getProcessor().setWait(!mp.getProcessor().isWait());
                        mp.updatePlayers();
                        break;
                    }
                    case RESET: {
                        mp.reset();
                        break;
                    }
                    case STEP: {
                        mp.getProcessor().setStep(true);
                    }
                }
            }
            catch (Exception e) {
                Minecoprocessors.proxy.handleUnexpectedException(e);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageProcessorAction, IMessage> {
        public IMessage onMessage(MessageProcessorAction message, MessageContext ctx) {
            if (message.action == null) {
                return null;
            }
            EntityPlayerMP payer = ctx.getServerHandler().field_147369_b;
            payer.func_71121_q().func_152344_a((Runnable)new Worker(payer, message));
            return null;
        }
    }

    public static enum Action {
        RESET,
        PAUSE,
        STEP;

    }
}

