/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.gui.GuiMinecoprocessor;
import net.torocraft.minecoprocessors.network.MessageEnableGuiUpdates;

public class MessageProcessorUpdate
implements IMessage {
    public BlockPos pos;
    public String name;
    public NBTTagCompound processorData;

    public static void init(int packetId) {
        Minecoprocessors.NETWORK.registerMessage(Handler.class, MessageProcessorUpdate.class, packetId, Side.CLIENT);
    }

    public MessageProcessorUpdate() {
    }

    public MessageProcessorUpdate(NBTTagCompound processorData, BlockPos pos, String name) {
        this.processorData = processorData;
        this.pos = pos;
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.processorData = ByteBufUtils.readTag((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.processorData);
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public static class Handler
    implements IMessageHandler<MessageProcessorUpdate, IMessage> {
        public IMessage onMessage(final MessageProcessorUpdate message, MessageContext ctx) {
            if (message.processorData == null || message.processorData == null) {
                return null;
            }
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (GuiMinecoprocessor.INSTANCE == null) {
                        return;
                    }
                    if (!GuiMinecoprocessor.INSTANCE.getPos().equals((Object)message.pos)) {
                        Minecoprocessors.NETWORK.sendToServer((IMessage)new MessageEnableGuiUpdates(message.pos, false));
                        return;
                    }
                    GuiMinecoprocessor.INSTANCE.updateData(message.processorData, message.name);
                }
            });
            return null;
        }
    }
}

