/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.util;

import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class RedstoneUtil {
    public static EnumFacing convertPortIndexToFacing(EnumFacing facing, int portIndex) {
        int rotation = RedstoneUtil.getRotation(facing);
        return RedstoneUtil.rotateFacing(EnumFacing.func_82600_a((int)(portIndex + 2)), rotation);
    }

    public static int convertFacingToPortIndex(EnumFacing facing, EnumFacing side) {
        int rotation = RedstoneUtil.getRotation(facing);
        return RedstoneUtil.rotateFacing(side, -rotation).func_176745_a() - 2;
    }

    private static EnumFacing rotateFacing(EnumFacing facing, int rotation) {
        if (rotation >= 0) {
            for (int i = 0; i < rotation; ++i) {
                facing = facing.func_176746_e();
            }
        } else {
            rotation = -rotation;
            for (int i = 0; i < rotation; ++i) {
                facing = facing.func_176735_f();
            }
        }
        return facing;
    }

    private static int getRotation(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return -1;
    }

    public static int portToPower(byte port) {
        return port & 0xF;
    }

    public static byte powerToPort(int powerValue) {
        return (byte)Math.min(powerValue, 15);
    }

    public static boolean isFrontPort(IBlockState blockState, EnumFacing side) {
        return blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == side;
    }

    public static boolean isBackPort(IBlockState blockState, EnumFacing side) {
        return ((EnumFacing)blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d() == side;
    }

    public static boolean isLeftPort(IBlockState blockState, EnumFacing side) {
        return ((EnumFacing)blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176735_f() == side;
    }

    public static boolean isRightPort(IBlockState blockState, EnumFacing side) {
        return ((EnumFacing)blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176746_e() == side;
    }

    public static BlockPos getFrontBlock(IBlockAccess blockAccess, BlockPos pos) {
        return pos.func_177972_a((EnumFacing)blockAccess.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D));
    }
}

