/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;
import team.chisel.client.gui.ButtonChiselMode;
import team.chisel.common.inventory.ContainerChisel;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.item.PacketChiselMode;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class GuiChisel
extends GuiContainer {
    public EntityPlayer player;
    public ContainerChisel container;

    public GuiChisel(InventoryPlayer iinventory, InventoryChiselSelection menu, EnumHand hand) {
        super((Container)new ContainerChisel(iinventory, menu, hand));
        this.player = iinventory.field_70458_d;
        this.field_146999_f = 252;
        this.field_147000_g = 202;
        this.container = (ContainerChisel)this.field_147002_h;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.field_147002_h.func_75134_a(this.player);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && slot.field_75222_d < this.container.getInventoryChisel().size - 1) {
            this.field_146993_M = false;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 0;
        Rectangle area = this.getModeButtonArea();
        int buttonsPerRow = area.getWidth() / 20;
        int padding = (area.getWidth() - buttonsPerRow * 20) / buttonsPerRow;
        IChiselMode currentMode = NBTUtil.getChiselMode(this.container.getChisel());
        for (IChiselMode mode : CarvingUtils.getModeRegistry().getAllModes()) {
            if (!((IChiselItem)this.container.getChisel().func_77973_b()).supportsMode(this.player, this.container.getChisel(), mode)) continue;
            int x = area.getX() + padding / 2 + id % buttonsPerRow * (20 + padding);
            int y = area.getY() + id / buttonsPerRow * (20 + padding);
            ButtonChiselMode button = new ButtonChiselMode(id++, x, y, mode);
            if (mode == currentMode) {
                button.field_146124_l = false;
            }
            this.setButtonText((ButtonChiselMode)this.func_189646_b(button));
        }
    }

    protected Rectangle getModeButtonArea() {
        int down = 67;
        int padding = 7;
        return new Rectangle(this.field_147003_i + padding, this.field_147009_r + down + padding, 50, this.field_147000_g - down - padding * 2);
    }

    private void setButtonText(ButtonChiselMode button) {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int j, int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String line = I18n.func_135052_a((String)(this.container.getInventoryChisel().func_70005_c_() + ".title"), (Object[])new Object[0]);
        List lines = this.field_146289_q.func_78271_c(line, 40);
        int y = 60;
        for (String s : lines) {
            this.field_146289_q.func_78276_b(s, 32 - this.field_146289_q.func_78256_a(s) / 2, y, 0x404040);
            y += 10;
        }
        this.drawButtonTooltips(j, i);
    }

    protected void drawButtonTooltips(int mx, int my) {
        for (GuiButton button : this.field_146292_n) {
            if (!button.func_146115_a() || !(button instanceof ButtonChiselMode)) continue;
            String unloc = ((ButtonChiselMode)button).getMode().getUnlocName();
            ArrayList ttLines = Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)(unloc + ".name"), (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)(unloc + ".desc"), (Object[])new Object[0])});
            GuiUtils.drawHoveringText((List)ttLines, (int)(mx - this.field_147003_i), (int)(my - this.field_147009_r), (int)(this.field_146294_l - this.field_147003_i), (int)(this.field_146295_m - this.field_147009_r), (int)-1, (FontRenderer)this.field_146289_q);
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_146294_l - this.field_146999_f >> 1;
        int j = this.field_146295_m - this.field_147000_g >> 1;
        String texture = "chisel:textures/chisel2Gui.png";
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(texture));
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        Slot main = (Slot)this.container.field_75151_b.get(this.container.getInventoryChisel().size);
        if (main.func_75211_c() == null) {
            GuiChisel.drawSlotOverlay(this, x + 14, y + 14, main, 0, this.field_147000_g, 60);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof ButtonChiselMode) {
            button.field_146124_l = false;
            IChiselMode mode = ((ButtonChiselMode)button).getMode();
            NBTUtil.setChiselMode(this.container.getChisel(), mode);
            Chisel.network.sendToServer((IMessage)new PacketChiselMode(this.container.getChiselSlot(), mode));
            for (GuiButton other : this.field_146292_n) {
                if (other == button || !(other instanceof ButtonChiselMode)) continue;
                other.field_146124_l = true;
            }
        }
        super.func_146284_a(button);
    }

    protected void func_146977_a(Slot slot) {
        if (slot instanceof SlotChiselInput) {
            GL11.glPushMatrix();
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            slot.field_75223_e -= 16;
            slot.field_75221_f -= 16;
            super.func_146977_a(slot);
            slot.field_75223_e += 16;
            slot.field_75221_f += 16;
            GL11.glPopMatrix();
        } else {
            super.func_146977_a(slot);
        }
    }

    public static void drawSlotOverlay(GuiContainer gui, int x, int y, Slot slot, int u, int v, int padding) {
        gui.func_73729_b(x + (slot.field_75223_e - (padding /= 2)), y + (slot.field_75221_f - padding), u, v, 18 + padding, 18 + padding);
    }
}

