/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.item;

import com.google.common.collect.Lists;
import gr8pefish.ironbackpacks.IronBackpacks;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.IBackpack;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackType;
import gr8pefish.ironbackpacks.api.upgrade.BackpackUpgrade;
import gr8pefish.ironbackpacks.capabilities.ItemBackpackHandler;
import gr8pefish.ironbackpacks.core.RegistrarIronBackpacks;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemBackpack
extends Item
implements IBackpack {
    public ItemBackpack() {
        this.func_77655_b("ironbackpacks.backpack");
        this.func_77627_a(true);
        this.func_77637_a(IronBackpacks.TAB_IB);
        this.func_77625_d(1);
    }

    public String func_77667_c(ItemStack stack) {
        BackpackInfo backpackInfo = this.getBackpackInfo(stack);
        return super.func_77667_c(stack) + "." + backpackInfo.getVariant().getBackpackType().getIdentifier().toString().replace(":", ".");
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        return new ItemBackpackHandler(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        BackpackInfo info = this.getBackpackInfo(held);
        if (info.getOwner() == null) {
            info.setOwner(player.func_146103_bH().getId());
            this.updateBackpack(held, info);
        }
        if (info.hasUpgrade(RegistrarIronBackpacks.UPGRADE_LOCK) && !player.func_146103_bH().getId().equals(info.getOwner())) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)held);
        }
        world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, RegistrarIronBackpacks.BACKPACK_OPEN, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        player.openGui((Object)IronBackpacks.INSTANCE, 0, world, hand == EnumHand.OFF_HAND ? 1 : 0, 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)held);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ArrayList sortedTypes = Lists.newArrayList(IronBackpacksAPI.getBackpackTypes());
        sortedTypes.sort(Comparator.comparingInt(BackpackType::getTier));
        for (BackpackType backpackType : sortedTypes) {
            if (backpackType.getIdentifier().equals((Object)IronBackpacksAPI.NULL)) continue;
            if (!backpackType.hasSpecialties()) {
                subItems.add((Object)IronBackpacksAPI.getStack(backpackType, BackpackSpecialty.NONE));
                continue;
            }
            for (BackpackSpecialty specialty : BackpackSpecialty.values()) {
                if (specialty == BackpackSpecialty.NONE) continue;
                subItems.add((Object)IronBackpacksAPI.getStack(backpackType, specialty));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getBackpackInfo(stack).hasUpgrade(RegistrarIronBackpacks.UPGRADE_DAMAGE_BAR);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int total = 0;
        int full = 0;
        BackpackInfo backpackInfo = this.getBackpackInfo(stack);
        for (int i = 0; i < backpackInfo.getInventory().getSlots(); ++i) {
            ItemStack invStack = backpackInfo.getInventory().getStackInSlot(i);
            if (!invStack.func_190926_b()) {
                full += invStack.func_190916_E();
                total += invStack.func_77976_d();
                continue;
            }
            total += 64;
        }
        return 1.0 - (double)full / (double)total;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        BackpackInfo backpackInfo = this.getBackpackInfo(stack);
        if (backpackInfo.getVariant().getBackpackType().hasSpecialties()) {
            tooltip.add(I18n.func_135052_a((String)("tooltip.ironbackpacks.backpack.emphasis." + backpackInfo.getVariant().getBackpackSpecialty().func_176610_l()), (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.ironbackpacks.backpack.tier", (Object[])new Object[]{backpackInfo.getVariant().getBackpackType().getTier() + 1}));
        tooltip.add(I18n.func_135052_a((String)"tooltip.ironbackpacks.backpack.upgrade.used", (Object[])new Object[]{backpackInfo.getPointsUsed(), backpackInfo.getMaxPoints()}));
        if (!Keyboard.isKeyDown((int)42) && !backpackInfo.getUpgrades().isEmpty()) {
            tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.ironbackpacks.shift", (Object[])new Object[0]));
        } else if (!backpackInfo.getUpgrades().isEmpty()) {
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"tooltip.ironbackpacks.backpack.upgrade.list", (Object[])new Object[]{backpackInfo.getPointsUsed(), backpackInfo.getMaxPoints()}));
            for (BackpackUpgrade upgrade : backpackInfo.getUpgrades()) {
                tooltip.add("  - " + I18n.func_135052_a((String)("upgrade.ironbackpacks." + upgrade.getIdentifier().func_110623_a() + ".name"), (Object[])new Object[0]));
            }
        }
    }
}

