/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;

public class CraftType
implements Comparable<CraftType> {
    private static Map<Integer, Map<Integer, CraftType>> cache = new HashMap<Integer, Map<Integer, CraftType>>();
    private static Map<ArrayList, CraftType> arrayListCache = new HashMap<ArrayList, CraftType>();
    private int itemID;
    private int damage;
    private Item item;
    private Object stack;

    private CraftType(Item item, int itemDamage) {
        this.item = item;
        this.itemID = Item.func_150891_b((Item)item);
        this.damage = itemDamage;
        this.stack = new ItemStack(item, 1, this.damage);
    }

    private CraftType(ArrayList<ItemStack> items) {
        ItemStack itemStack = items.get(0);
        this.item = itemStack.func_77973_b();
        this.itemID = Item.func_150891_b((Item)this.item);
        this.damage = CommonUtilities.getItemDamage(itemStack);
        this.stack = items;
    }

    public static CraftType getInstance(Object stack) {
        if (stack instanceof ItemStack) {
            return CraftType.getInstance((ItemStack)stack);
        }
        if (stack instanceof ArrayList && ((ArrayList)stack).size() > 0) {
            return CraftType.getInstance((ArrayList)stack);
        }
        return null;
    }

    private static CraftType getInstance(ArrayList stack) {
        CraftType type = arrayListCache.get(stack);
        if (type == null) {
            type = new CraftType(stack);
            arrayListCache.put(stack, type);
        }
        return type;
    }

    private static CraftType getInstance(ItemStack stack) {
        CraftType type;
        int id = Item.func_150891_b((Item)stack.func_77973_b());
        Map<Integer, CraftType> map = cache.get(id);
        if (map == null) {
            map = new HashMap<Integer, CraftType>();
            cache.put(id, map);
        }
        if ((type = map.get(CommonUtilities.getItemDamage(stack))) == null) {
            type = new CraftType(stack.func_77973_b(), CommonUtilities.getItemDamage(stack));
            map.put(CommonUtilities.getItemDamage(stack), type);
        }
        return type;
    }

    public static boolean hasInstance(ItemStack stack) {
        int id = Item.func_150891_b((Item)stack.func_77973_b());
        if (!cache.containsKey(id)) {
            return false;
        }
        return cache.get(id).containsKey(CommonUtilities.getItemDamage(stack));
    }

    @Override
    public int compareTo(CraftType other) {
        if (this.itemID != other.itemID) {
            return this.itemID > other.itemID ? 1 : -1;
        }
        if (this.damage != other.damage) {
            return this.damage > other.damage ? 1 : -1;
        }
        if (this.stack instanceof ArrayList != other.stack instanceof ArrayList) {
            return this.stack instanceof ArrayList ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CraftType) {
            CraftType type = (CraftType)obj;
            if (this.stack instanceof ItemStack && type.stack instanceof ItemStack) {
                return type.itemID == this.itemID && type.damage == this.damage;
            }
            if (this.stack instanceof ArrayList && type.stack instanceof ArrayList) {
                return this.stack.equals(type.stack);
            }
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.damage * 3571 + this.itemID;
    }

    public Object getStack() {
        return this.stack;
    }

    public ItemStack getDisplayStack() {
        if (this.stack instanceof ItemStack) {
            return (ItemStack)this.stack;
        }
        if (this.stack instanceof ArrayList) {
            return (ItemStack)((ArrayList)this.stack).get(0);
        }
        return null;
    }
}

