/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.CraftGuideRecipeExtra1;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.gui_craftguide.rendering.Renderable;

public class Recipe
implements CraftGuideRecipe,
CraftGuideRecipeExtra1 {
    protected Slot[] slots;
    protected Object[] recipe;
    public Renderable background;
    public Renderable backgroundSelected;
    private int width = 79;
    private int height = 58;

    public Recipe(Slot[] slots, Object[] items, Renderable background, Renderable backgroundSelected) {
        int i;
        this.slots = slots;
        this.recipe = new Object[items.length];
        for (i = 0; i < items.length; ++i) {
            this.recipe[i] = items[i];
        }
        this.background = background;
        this.backgroundSelected = backgroundSelected;
        for (i = 0; i < slots.length; ++i) {
            ItemStack display = this.displayStack(this.recipe[i]);
            if (!(this.recipe[i] instanceof ItemStack) || !(slots[i] instanceof ItemSlot) || ((ItemSlot)slots[i]).drawQuantity || display == null || display.field_77994_a <= 1) continue;
            ItemStack old = display;
            this.recipe[i] = new ItemStack(old.func_77973_b(), 1, CommonUtilities.getItemDamage(old));
        }
    }

    private ItemStack displayStack(Object item) {
        if (item == null) {
            return null;
        }
        if (item instanceof ItemStack) {
            return (ItemStack)item;
        }
        if (item instanceof ArrayList) {
            if (((ArrayList)item).size() < 1) {
                return null;
            }
            return this.displayStack(((ArrayList)item).get(0));
        }
        return null;
    }

    @Override
    public void draw(Renderer renderer, int x, int y, boolean mouseOverRecipe, int mouseX, int mouseY) {
        if (mouseOverRecipe) {
            this.backgroundSelected.render((GuiRenderer)renderer, x, y);
        } else {
            this.background.render((GuiRenderer)renderer, x, y);
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (mouseOverRecipe) {
                boolean mouseOverSlot = this.slots[i].isPointInBounds(mouseX, mouseY, this.recipe, i);
                this.slots[i].draw(renderer, x, y, this.recipe, i, mouseOverSlot);
                continue;
            }
            this.slots[i].draw(renderer, x, y, this.recipe, i, false);
        }
    }

    public int getSlotIndexUnderMouse(int x, int y) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (!this.slots[i].isPointInBounds(x, y, this.recipe, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        ItemFilter filter = Util.instance.getCommonFilter(stack);
        return this.containsItem(filter);
    }

    @Override
    public boolean containsItem(ItemFilter filter) {
        return this.containsItem(filter, SlotType.ANY_SLOT);
    }

    @Override
    public boolean containsItem(ItemStack stack, SlotType type) {
        ItemFilter filter = Util.instance.getCommonFilter(stack);
        return this.containsItem(filter, type);
    }

    @Override
    public boolean containsItem(ItemFilter filter, SlotType type) {
        if (filter != null) {
            for (int i = 0; i < this.slots.length; ++i) {
                try {
                    if (!this.slots[i].matches(filter, this.recipe, i, type)) continue;
                    return true;
                }
                catch (Throwable e) {
                    CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.Recipe.containsItem, while checking slot #" + i + " " + (this.slots[i] != null ? this.slots[i].getClass() : "null slot"));
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    @Override
    public Object[] getItems() {
        return this.recipe;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    public Recipe setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public List<String> getItemText(int x, int y) {
        int slot = this.getSlotIndexUnderMouse(x, y);
        if (slot == -1 || this.slots[slot] == null) {
            return null;
        }
        return this.slots[slot].getTooltip(x, y, this.recipe, slot);
    }

    @Override
    public ItemFilter getRecipeClickedResult(int x, int y) {
        int slot = this.getSlotIndexUnderMouse(x, y);
        if (slot == -1 || this.slots[slot] == null) {
            return null;
        }
        return this.slots[slot].getClickedFilter(x, y, this.recipe, slot);
    }

    public Slot[] getSlotData() {
        return this.slots;
    }
}

