/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.Util;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.filters.EmptyOreDictionaryFilter;
import uristqwerty.CraftGuide.filters.MultipleItemFilter;
import uristqwerty.CraftGuide.filters.NoItemFilter;
import uristqwerty.CraftGuide.filters.SingleItemFilter;
import uristqwerty.CraftGuide.filters.StringItemFilter;

public abstract class UtilImplementationCommon
extends Util {
    private static final List<ItemStack> specialEmptyItemList = new ArrayList<ItemStack>(0);
    public float partialTicks;

    @Override
    public ItemFilter getCommonFilter(Object stack) {
        if (stack == null) {
            return null;
        }
        if (stack instanceof ItemStack) {
            return new SingleItemFilter((ItemStack)stack);
        }
        if (stack instanceof List) {
            if (((List)stack).size() > 0) {
                return new MultipleItemFilter((List)stack);
            }
            if (stack == specialEmptyItemList) {
                return new NoItemFilter();
            }
            String oreDictionaryName = ForgeExtensions.getOreDictionaryName((List)stack);
            if (oreDictionaryName != null) {
                return new EmptyOreDictionaryFilter((List)stack, oreDictionaryName);
            }
        } else if (stack instanceof String) {
            return new StringItemFilter((String)stack);
        }
        return null;
    }

    @Override
    public List<String> getItemStackText(ItemStack stack) {
        try {
            List<String> list = ((GuiRenderer)GuiRenderer.instance).getItemNameandInformation(stack);
            if (CommonUtilities.getItemDamage(stack) == Short.MAX_VALUE && (list.size() < 1 || list.size() == 1 && (list.get(0) == null || list.get(0).isEmpty()))) {
                list = ((GuiRenderer)GuiRenderer.instance).getItemNameandInformation(GuiRenderer.fixedItemStack(stack));
            }
            ArrayList<String> text = new ArrayList<String>(list.size());
            boolean first = true;
            for (String o : list) {
                if (!(o instanceof String)) continue;
                if (first) {
                    EnumRarity rarity = null;
                    try {
                        rarity = stack.func_77953_t();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (rarity == null) {
                        rarity = EnumRarity.common;
                    }
                    text.add(rarity.field_77937_e + o);
                    if (CraftGuide.alwaysShowID) {
                        text.add(EnumChatFormatting.DARK_GRAY + "ID: " + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + "; data: " + CommonUtilities.getItemDamage(stack) + (stack.func_77942_o() ? "; NBT: " + Integer.toHexString(stack.func_77978_p().hashCode()) : ""));
                    }
                    first = false;
                    continue;
                }
                text.add(EnumChatFormatting.DARK_GRAY + o);
            }
            return text;
        }
        catch (Exception e) {
            CraftGuideLog.log(e);
            ArrayList<String> text = new ArrayList<String>(1);
            text.add(EnumChatFormatting.YELLOW + "Item " + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + " data " + Integer.toString(CommonUtilities.getItemDamage(stack)));
            return text;
        }
    }

    @Override
    public void reloadRecipes() {
        CraftGuide.side.reloadRecipes();
    }

    @Override
    public float getPartialTicks() {
        return this.partialTicks;
    }

    @Override
    public List<ItemStack> addItemLists(List<ItemStack> a, List<ItemStack> b) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        this.addUniqueItemsToList(result, a);
        this.addUniqueItemsToList(result, b);
        return result;
    }

    @Override
    public List<ItemStack> subtractItemLists(List<ItemStack> a, List<ItemStack> b) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        this.addUniqueItemsToList(result, a);
        this.removeItemsFromList(result, b);
        if (result.isEmpty()) {
            return specialEmptyItemList;
        }
        return result;
    }

    private void addUniqueItemsToList(ArrayList<ItemStack> result, List<ItemStack> a) {
        block0: for (ItemStack item : a) {
            for (ItemStack t : result) {
                if (!CommonUtilities.checkItemStackMatch(item, t)) continue;
                continue block0;
            }
            result.add(item);
        }
    }

    private void removeItemsFromList(ArrayList<ItemStack> result, List<ItemStack> a) {
        Iterator<ItemStack> i = result.iterator();
        block0: while (i.hasNext()) {
            ItemStack stack = i.next();
            for (ItemStack t : a) {
                if (!CommonUtilities.checkItemStackMatch(stack, t)) continue;
                i.remove();
                continue block0;
            }
        }
    }
}

