/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.PseudoFluidStack;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;

public class PseudoFluidFilter
implements ItemFilter {
    private static NamedTexture containerTexture = null;
    public PseudoFluidStack liquid;
    private String liquidName;
    private List<String> tooltip = new ArrayList<String>();

    public PseudoFluidFilter(PseudoFluidStack liquid) {
        if (containerTexture == null) {
            containerTexture = Util.instance.getTexture("liquidFilterContainer");
        }
        this.setLiquid(liquid);
    }

    public void setLiquid(PseudoFluidStack liquid) {
        String name = liquid.getLocalizedName();
        this.liquid = liquid;
        this.liquidName = name.toLowerCase();
        this.tooltip.clear();
        this.tooltip.add(name);
    }

    @Override
    public boolean matches(Object item) {
        if (item instanceof PseudoFluidStack) {
            return this.liquid.isFluidEqual((PseudoFluidStack)item);
        }
        if (item instanceof String) {
            return this.liquidName.contains(((String)item).toLowerCase());
        }
        if (item instanceof List) {
            for (Object object : (List)item) {
                if (!this.matches(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        if (this.liquid != null) {
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            IIcon icon = this.liquid.getIcon();
            if (icon != null) {
                textureManager.func_110577_a(TextureMap.field_110575_b);
                double u = icon.func_94214_a(3.0);
                double u2 = icon.func_94214_a(13.0);
                double v = icon.func_94207_b(1.0);
                double v2 = icon.func_94207_b(15.0);
                GL11.glEnable((int)3553);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                GL11.glBegin((int)7);
                GL11.glTexCoord2d((double)u, (double)v);
                GL11.glVertex2i((int)(x + 3), (int)(y + 1));
                GL11.glTexCoord2d((double)u, (double)v2);
                GL11.glVertex2i((int)(x + 3), (int)(y + 15));
                GL11.glTexCoord2d((double)u2, (double)v2);
                GL11.glVertex2i((int)(x + 13), (int)(y + 15));
                GL11.glTexCoord2d((double)u2, (double)v);
                GL11.glVertex2i((int)(x + 13), (int)(y + 1));
                GL11.glEnd();
            }
        }
        renderer.renderRect(x - 1, y - 1, 18, 18, containerTexture);
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }
}

