/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.StatCollector;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.GuiCraftGuide;
import uristqwerty.CraftGuide.client.ui.ButtonTemplate;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiScrollableContent;
import uristqwerty.CraftGuide.client.ui.IButtonListener;
import uristqwerty.CraftGuide.client.ui.ToggleButton;
import uristqwerty.CraftGuide.client.ui.text.TextSource;
import uristqwerty.CraftGuide.client.ui.text.TranslatedTextSource;
import uristqwerty.CraftGuide.dump.HTMLExport;
import uristqwerty.CraftGuide.dump.JsonRecipeDump;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.minecraft.MultilineText;
import uristqwerty.gui_craftguide.theme.ThemeManager;

public class ConfigList
extends GuiScrollableContent {
    static final int BORDER_THICKNESS = 3;
    private List<ConfigEntry> options = new ArrayList<ConfigEntry>();
    private GuiElement innerPanel;
    private CurrentThemeTextSource currentThemeSource;

    public ConfigList(int x, int y, int width, int height, GuiScrollBar scrollBar, ButtonTemplate buttonTemplate, ButtonTemplate toggleTemplate) {
        super(x, y, width, height, scrollBar);
        this.innerPanel = new GuiElement(0, 0, width, height);
        this.addElement(this.innerPanel);
        this.addToggle("craftguide.gui.config.pause", toggleTemplate, CraftGuide.pauseWhileOpen, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.pauseWhileOpen = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.show_ids", toggleTemplate, CraftGuide.alwaysShowID, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.alwaysShowID = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.enable_keybind", toggleTemplate, CraftGuide.enableKeybind, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.enableKeybind = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.enable_item_recipe", toggleTemplate, CraftGuide.enableItemRecipe, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.enableItemRecipe = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.hide_mundane_potions", toggleTemplate, CraftGuide.hideMundanePotionRecipes, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.hideMundanePotionRecipes = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.theme_debugging", toggleTemplate, ThemeManager.debugOutput, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                ThemeManager.debugOutput = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.textinput_clear_on_right_click", toggleTemplate, CraftGuide.rightClickClearText, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.rightClickClearText = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addToggle("craftguide.gui.config.ae2_workaround", toggleTemplate, CraftGuide.ae2Workaround, new ToggleConfig(){

            @Override
            public void onToggle(boolean newState) {
                CraftGuide.ae2Workaround = newState;
                CraftGuide.saveConfig();
            }
        });
        this.addButton("craftguide.gui.config.reload_recipes", "craftguide.gui.config.reload_recipes.button", buttonTemplate, new IButtonListener(){

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event event) {
                if (event == IButtonListener.Event.PRESS) {
                    GuiCraftGuide.getInstance().reloadRecipes();
                }
            }
        });
        this.addButton("craftguide.gui.config.export_displayed_recipes", "craftguide.gui.config.export_displayed_recipes.button", buttonTemplate, new IButtonListener(){

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event event) {
                if (event == IButtonListener.Event.PRESS) {
                    try {
                        FileOutputStream output = new FileOutputStream(new File(Minecraft.func_71410_x().field_71412_D, "CraftGuide_DisplayedRecipes.json"));
                        new JsonRecipeDump().exportDisplayedRecipes(output);
                        output.close();
                    }
                    catch (IOException e) {
                        CraftGuideLog.log(e, "", true);
                    }
                }
            }
        });
        this.addButton("craftguide.gui.config.export_crafting_recipes", "craftguide.gui.config.export_crafting_recipes.button", buttonTemplate, new IButtonListener(){

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event event) {
                if (event == IButtonListener.Event.PRESS) {
                    try {
                        FileOutputStream output = new FileOutputStream(new File(Minecraft.func_71410_x().field_71412_D, "CraftGuide_CraftingRecipes.json"));
                        new JsonRecipeDump().dumpCraftingRecipes(output);
                        output.close();
                    }
                    catch (IOException e) {
                        CraftGuideLog.log(e, "", true);
                    }
                }
            }
        });
        this.addButton("craftguide.gui.config.test_html_export", "craftguide.gui.config.test_html_export.button", buttonTemplate, new IButtonListener(){

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event event) {
                if (event == IButtonListener.Event.PRESS) {
                    try {
                        HTMLExport.test();
                    }
                    catch (Exception e) {
                        CraftGuideLog.log(e, "", true);
                    }
                }
            }
        });
        this.addThemeButton(buttonTemplate);
        this.updateScrollbarScale();
    }

    private void addButton(String text, String buttonText, ButtonTemplate buttonTemplate, IButtonListener listener) {
        String translatedButtonText = StatCollector.func_74838_a((String)buttonText);
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(translatedButtonText);
        this.addRow(text, new GuiButton(3, 3, Math.max(32, textWidth + 4), 13, buttonTemplate, translatedButtonText).addButtonListener(listener).anchor(GuiElement.AnchorPoint.TOP_RIGHT));
    }

    private void addToggle(String text, ButtonTemplate toggleTemplate, boolean initialState, final ToggleConfig onToggle) {
        this.addRow(text, new ToggleButton(3, 3, 13, 13, toggleTemplate).setState(initialState ? GuiButton.ButtonState.DOWN : GuiButton.ButtonState.UP).addButtonListener(new IButtonListener(){

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
                if (eventType == IButtonListener.Event.PRESS) {
                    onToggle.onToggle(true);
                } else if (eventType == IButtonListener.Event.RELEASE) {
                    onToggle.onToggle(false);
                }
            }
        }).anchor(GuiElement.AnchorPoint.TOP_RIGHT));
    }

    private void addRow(String text, GuiElement element) {
        int pos = 0;
        if (this.options.size() > 0) {
            ConfigEntry last = this.options.get(this.options.size() - 1);
            pos = last.relativeY() + last.height();
        }
        ConfigEntry entry = new ConfigEntry(text, element, pos);
        this.options.add(entry);
        this.innerPanel.addElement(entry);
    }

    private void addThemeButton(ButtonTemplate buttonTemplate) {
        String translatedButtonText = StatCollector.func_74838_a((String)"craftguide.gui.config.current_theme.button");
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(translatedButtonText);
        this.addThemeRow(new GuiButton(3, 3, Math.max(32, textWidth + 4), 13, buttonTemplate, translatedButtonText).addButtonListener(new IButtonListener(){

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event event) {
                if (event == IButtonListener.Event.PRESS) {
                    ConfigList.this.nextTheme();
                }
            }
        }).anchor(GuiElement.AnchorPoint.TOP_RIGHT));
    }

    private void addThemeRow(GuiElement element) {
        int pos = 0;
        if (this.options.size() > 0) {
            ConfigEntry last = this.options.get(this.options.size() - 1);
            pos = last.relativeY() + last.height();
        }
        this.currentThemeSource = new CurrentThemeTextSource();
        this.currentThemeSource.currentThemeName = ThemeManager.currentThemeName;
        ConfigEntry entry = new ConfigEntry(this.currentThemeSource, element, pos);
        this.options.add(entry);
        this.innerPanel.addElement(entry);
    }

    void nextTheme() {
        Object[] themeNames = ThemeManager.instance.themeList.keySet().toArray(new String[0]);
        Arrays.sort(themeNames);
        int current = Arrays.binarySearch(themeNames, ThemeManager.currentThemeName);
        current = current < 0 ? 0 : (current + 1) % themeNames.length;
        ThemeManager.currentTheme = ThemeManager.instance.buildTheme((String)themeNames[current]);
        ThemeManager.currentThemeName = themeNames[current];
        this.currentThemeSource.themeChanged(ThemeManager.instance.themeList.get((Object)themeNames[current]).name);
    }

    @Override
    public void onResize(int oldWidth, int oldHeight) {
        super.onResize(oldWidth, oldHeight);
        if (this.width() != oldWidth) {
            this.widthChanged();
        }
    }

    private void widthChanged() {
        boolean heightChange = false;
        for (ConfigEntry entry : this.options) {
            int prevHeight = entry.height();
            entry.setSize(this.width(), entry.height());
            entry.recalculateHeight();
            if (entry.height() == prevHeight) continue;
            heightChange = true;
        }
        if (heightChange) {
            this.recalculatePositions();
        }
    }

    private void recalculatePositions() {
        int pos = 0;
        for (ConfigEntry entry : this.options) {
            entry.setPosition(0, pos);
            pos += entry.height();
        }
        this.innerPanel.setSize(this.width(), pos);
        this.updateScrollbarScale();
    }

    public void entryHeightChanged(ConfigEntry configEntry) {
        this.recalculatePositions();
    }

    public void updateScrollbarScale() {
        float end = 0.0f;
        if (this.options.size() > 0) {
            ConfigEntry last = this.options.get(this.options.size() - 1);
            end = last.relativeY() + last.height() - this.height();
        }
        if (end < 0.0f) {
            end = 0.0f;
        }
        this.scrollBar.setRowSize(8);
        this.scrollBar.setScale(0.0f, end);
    }

    static String[] layoutText(String text, int width) {
        if (width < 64) {
            width = 64;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        List lines = fr.func_78271_c(text, width);
        return lines.toArray(new String[lines.size()]);
    }

    @Override
    public void drawChildren() {
        GuiRenderer renderer = this.getRenderer();
        renderer.setClippingRegion(this.absoluteX() + 1, this.absoluteY() + 1, this.width() - 2, this.height() - 2);
        this.innerPanel.setPosition(0, -((int)this.scrollBar.getValue()));
        try {
            super.drawChildren();
        }
        finally {
            renderer.clearClippingRegion();
        }
    }

    @Override
    public void mouseMoved(int x, int y) {
        this.innerPanel.setPosition(0, -((int)this.scrollBar.getValue()));
        super.mouseMoved(x, y);
    }

    @Override
    public void mousePressed(int x, int y) {
        this.innerPanel.setPosition(0, -((int)this.scrollBar.getValue()));
        super.mousePressed(x, y);
    }

    private static class CurrentThemeTextSource
    extends TextSource
    implements TextSource.TextChangeListener {
        TextSource source = new TranslatedTextSource("craftguide.gui.config.current_theme.format_string");
        String currentThemeName;

        public CurrentThemeTextSource() {
            this.source.addListener(this);
        }

        @Override
        public String getText() {
            try {
                return String.format(this.source.getText(), this.currentThemeName);
            }
            catch (IllegalFormatException e) {
                CraftGuideLog.log(e);
                return "Current theme: " + this.currentThemeName;
            }
        }

        @Override
        public void onTextChanged(TextSource source) {
            this.sendTextChanged();
        }

        public void themeChanged(String newThemeName) {
            this.currentThemeName = newThemeName;
            this.sendTextChanged();
        }
    }

    static interface ToggleConfig {
        public void onToggle(boolean var1);
    }

    class ConfigEntry
    extends GuiElement
    implements TextSource.TextChangeListener {
        MultilineText textDisplay;
        TextSource translatedText;
        GuiElement element;

        public ConfigEntry(String text, GuiElement element, int pos) {
            this(new TranslatedTextSource(text), element, pos);
        }

        public ConfigEntry(TextSource text, GuiElement element, int pos) {
            super(0, pos, ConfigList.this.width(), 0);
            this.element = element;
            this.textDisplay = new MultilineText(3 + element.width() + 3, 3, null);
            this.translatedText = text;
            this.translatedText.addListener(this);
            this.addElement(element);
            this.recalculateHeight();
        }

        @Override
        public void onTextChanged(TextSource source) {
            int prevHeight = this.height();
            this.recalculateHeight();
            if (this.height() != prevHeight) {
                ConfigList.this.entryHeightChanged(this);
            }
        }

        private void recalculateHeight() {
            int textLeft = 3 + this.element.width() + 3;
            int textRight = this.width() - 3;
            String[] lines = ConfigList.layoutText(this.translatedText.getText(), textRight - textLeft);
            this.textDisplay.setText(lines);
            int textHeight = lines.length * 10 + 6;
            int elementHeight = this.element.height() + 6;
            int height = Math.max(textHeight, elementHeight);
            this.setSize(this.width(), height);
            if (textHeight > elementHeight) {
                this.textDisplay.setPosition(textLeft, 3);
                this.element.setPosition(3, (height - this.element.height()) / 2);
            } else {
                this.textDisplay.setPosition(textLeft, (height - lines.length * 10 + 1) / 2);
                this.element.setPosition(3, 3);
            }
        }

        @Override
        public void draw() {
            super.draw();
            this.render(this.textDisplay);
        }
    }
}

