/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.client.ui.Rendering.Overlay;
import uristqwerty.gui_craftguide.minecraft.Gui;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.rendering.TexturedRect;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.Texture;

public class GuiRenderer
extends RendererBase
implements Renderer {
    private double frameStartTime;
    private RenderItem itemRenderer = new RenderItem();
    private List<Overlay> overlays = new LinkedList<Overlay>();
    private Gui gui;
    private static Map<ItemStack, ItemStack> itemStackFixes = new HashMap<ItemStack, ItemStack>();
    private Renderable itemError = new TexturedRect(-1, -1, 18, 18, DynamicTexture.instance("item_error"), 238, 200);
    private HashSet<ItemStack> loggedStacks = new HashSet();
    private WeakHashMap<ItemStack, Void> invalidStacks = new WeakHashMap();

    public void startFrame(Gui gui) {
        this.gui = gui;
        this.resetValues();
        this.frameStartTime = (double)Minecraft.func_71386_F() / 1000.0;
    }

    public void endFrame() {
        for (Overlay overlay : this.overlays) {
            overlay.renderOverlay(this);
        }
        this.overlays.clear();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public void setColor(int colour, int alpha) {
        this.setColorRgb(colour);
        this.setAlpha(alpha);
    }

    @Override
    public void setTextureID(int textureID) {
        if (textureID != -1) {
            GL11.glBindTexture((int)3553, (int)textureID);
        }
    }

    public void drawGradient(int x, int y, int width, int height, int topColor, int bottomColor) {
        this.renderVerticalGradient(x, y, width, height, topColor, bottomColor);
    }

    public void render(Renderable renderable, int xOffset, int yOffset) {
        renderable.render(this, xOffset, yOffset);
    }

    public void overlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    @Override
    public void renderText(int x, int y, String text, int textColor, boolean drawShadow) {
        int prevColor = this.currentColor();
        this.setColor(textColor);
        if (drawShadow) {
            this.drawTextWithShadow(text, x, y);
        } else {
            this.drawText(text, x, y);
        }
        this.setColor(prevColor);
    }

    @Override
    public void drawText(String text, int x, int y) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, x, y, this.currentColor());
    }

    @Override
    public void drawTextWithShadow(String text, int x, int y) {
        Minecraft.func_71410_x().field_71466_p.func_78261_a(text, x, y, this.currentColor());
    }

    private int currentColor() {
        return ((int)(this.alpha * 255.0) & 0xFF) << 24 | ((int)(this.red * 255.0) & 0xFF) << 16 | ((int)(this.green * 255.0) & 0xFF) << 8 | (int)(this.blue * 255.0) & 0xFF;
    }

    public void drawFloatingText(int x, int y, String text) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(text);
        this.drawFloatingText(x, y, list);
    }

    public void drawFloatingText(int x, int y, List<String> text) {
        int textWidth = 0;
        int textHeight = text.size() > 1 ? text.size() * 10 : 8;
        for (String s : text) {
            int w = s.charAt(0) == '\u00a7' ? Minecraft.func_71410_x().field_71466_p.func_78256_a(s.substring(2)) : Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
            if (w <= textWidth) continue;
            textWidth = w;
        }
        int xMax = this.gui.field_146294_l - textWidth - 4;
        int yMax = this.gui.field_146295_m - textHeight - 4;
        if (x > xMax) {
            x = xMax;
        }
        if (x < 3) {
            x = 3;
        }
        if (y > yMax) {
            y = yMax;
        }
        if (y < 4) {
            y = 4;
        }
        this.setColor(-267386864);
        this.drawRect(x - 3, y - 4, textWidth + 6, 1);
        this.drawRect(x - 3, y + textHeight + 3, textWidth + 6, 1);
        this.drawRect(x - 3, y - 3, textWidth + 6, textHeight + 6);
        this.drawRect(x - 4, y - 3, 1, textHeight + 6);
        this.drawRect(x + textWidth + 3, y - 3, 1, textHeight + 6);
        this.setColor(0x505000FF);
        this.drawRect(x - 3, y - 3, textWidth + 6, 1);
        this.setColor(1344798847);
        this.drawRect(x - 3, y + textHeight + 2, textWidth + 6, 1);
        this.drawGradient(x - 3, y - 2, 1, textHeight + 4, 0x505000FF, 1344798847);
        this.drawGradient(x + textWidth + 2, y - 2, 1, textHeight + 4, 0x505000FF, 1344798847);
        this.setColor(-1);
        int textY = y;
        boolean first = true;
        for (String s : text) {
            this.drawTextWithShadow(s, x, textY);
            if (first) {
                textY += 2;
                first = false;
            }
            textY += 10;
        }
    }

    public void drawItemStack(ItemStack itemStack, int x, int y) {
        this.drawItemStack(itemStack, x, y, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, boolean renderOverlay) {
        if (itemStack == null) {
            return;
        }
        boolean error = true;
        int initialMatrixStackDepth = this.prepareGlForItemRender(x, y);
        try {
            itemStack = this.renderItem(itemStack, renderOverlay);
            error = false;
        }
        catch (Exception e) {
            this.logItemRenderException(itemStack, e);
        }
        catch (Error e) {
            CraftGuideLog.log(e);
            throw e;
        }
        finally {
            this.fixGlState(initialMatrixStackDepth);
        }
        if (error) {
            this.drawItemStackError(x, y);
        }
    }

    private void logItemRenderException(ItemStack itemStack, Exception e) {
        if (!this.hasLogged(itemStack)) {
            CraftGuideLog.log("Failed to render ItemStack {" + (itemStack == null ? "null" : "itemID = " + Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()) + ", itemDamage = " + CommonUtilities.getItemDamage(itemStack) + ", stackSize = " + itemStack.field_77994_a) + "} (Further stack traces from this particular ItemStack instance will not be logged)");
            CraftGuideLog.log(e);
        }
    }

    private ItemStack renderItem(ItemStack itemStack, boolean renderOverlay) {
        if (CommonUtilities.getItemDamage(itemStack) == Short.MAX_VALUE) {
            itemStack = GuiRenderer.fixedItemStack(itemStack);
        }
        this.itemRenderer.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemStack, 0, 0);
        if (renderOverlay) {
            this.itemRenderer.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemStack, 0, 0);
        }
        return itemStack;
    }

    private int prepareGlForItemRender(int x, int y) {
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        this.itemRenderer.field_77023_b = 100.0f;
        int initialMatrixStackDepth = GL11.glGetInteger((int)2979);
        return initialMatrixStackDepth;
    }

    private void fixGlState(int initialMatrixStackDepth) {
        for (int finalMatrixStackDepth = GL11.glGetInteger((int)2979); finalMatrixStackDepth > initialMatrixStackDepth; --finalMatrixStackDepth) {
            GL11.glPopMatrix();
        }
        CraftGuide.side.stopTessellating();
        this.itemRenderer.field_77023_b = 0.0f;
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    private boolean hasLogged(ItemStack stack) {
        return !this.loggedStacks.add(stack);
    }

    public static ItemStack fixedItemStack(ItemStack itemStack) {
        ItemStack stack = itemStackFixes.get(itemStack);
        if (stack == null) {
            stack = itemStack.func_77946_l();
            stack.func_77964_b(0);
            itemStackFixes.put(itemStack, stack);
        }
        return stack;
    }

    private void drawItemStackError(int x, int y) {
        this.itemError.render(this, x, y);
    }

    public void setClippingRegion(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        x = (int)((float)x * ((float)Minecraft.func_71410_x().field_71440_d / (float)this.gui.field_146295_m));
        y = (int)((float)y * ((float)Minecraft.func_71410_x().field_71443_c / (float)this.gui.field_146294_l));
        height = (int)((float)height * ((float)Minecraft.func_71410_x().field_71440_d / (float)this.gui.field_146295_m));
        width = (int)((float)width * ((float)Minecraft.func_71410_x().field_71443_c / (float)this.gui.field_146294_l));
        GL11.glScissor((int)x, (int)(Minecraft.func_71410_x().field_71440_d - y - height), (int)width, (int)height);
    }

    public void clearClippingRegion() {
        GL11.glDisable((int)3089);
    }

    public int guiXFromMouseX(int x) {
        return x * this.gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
    }

    public int guiYFromMouseY(int y) {
        return this.gui.field_146295_m - y * this.gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
    }

    @Override
    public void renderItemStack(int x, int y, ItemStack stack) {
        this.drawItemStack(stack, x, y);
    }

    @Override
    public void renderRect(int x, int y, int width, int height, NamedTexture texture) {
        if (texture != null) {
            this.setColor(255, 255, 255, 255);
            this.drawTexturedRect((Texture)((Object)texture), x, y, width, height, 0, 0);
        }
    }

    @Override
    public void renderRect(int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue, alpha);
        this.drawRect(x, y, width, height);
        this.setColor(255, 255, 255, 255);
    }

    @Override
    public void renderRect(int x, int y, int width, int height, int color_rgb, int alpha) {
        this.renderRect(x, y, width, height, color_rgb >> 16 & 0xFF, color_rgb >> 8 & 0xFF, color_rgb >> 0 & 0xFF, alpha);
    }

    @Override
    public void renderRect(int x, int y, int width, int height, int color_argb) {
        this.renderRect(x, y, width, height, color_argb & 0xFFFFFF, color_argb >> 24 & 0xFF);
    }

    @Override
    public void renderVerticalGradient(int x, int y, int width, int height, int topColor_argb, int bottomColor_argb) {
        this.renderGradient(x, y, width, height, topColor_argb, topColor_argb, bottomColor_argb, bottomColor_argb);
    }

    @Override
    public void renderHorizontalGradient(int x, int y, int width, int height, int leftColor_argb, int rightColor_argb) {
        this.renderGradient(x, y, width, height, leftColor_argb, rightColor_argb, leftColor_argb, rightColor_argb);
    }

    @Override
    public void renderGradient(int x, int y, int width, int height, int topLeftColor_argb, int topRightColor_argb, int bottomLeftColor_argb, int bottomRightColor_argb) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)7);
        this.glColor1i(topLeftColor_argb);
        GL11.glVertex2i((int)x, (int)y);
        this.glColor1i(bottomLeftColor_argb);
        GL11.glVertex2i((int)x, (int)(y + height));
        this.glColor1i(bottomRightColor_argb);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        this.glColor1i(topRightColor_argb);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void glColor1i(int color) {
        this.setGlColor((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color >> 0 & 0xFF) / 255.0, (double)(color >> 24 & 0xFF) / 255.0);
    }

    public List<String> getItemNameandInformation(ItemStack stack) {
        if (!this.invalidStacks.containsKey(stack) && stack.func_77973_b() != null) {
            try {
                return this.getTooltip(stack);
            }
            catch (Exception e) {
                try {
                    stack = GuiRenderer.fixedItemStack(stack);
                    return this.getTooltip(stack);
                }
                catch (Exception e2) {
                    CraftGuideLog.log(e2);
                }
            }
        }
        this.invalidStacks.put(stack, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.YELLOW + "Err: Item " + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + ", damage " + CommonUtilities.getItemDamage(stack));
        return list;
    }

    private List<String> getTooltip(ItemStack stack) {
        return stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
    }

    @Override
    public double getClock() {
        return this.frameStartTime;
    }
}

