/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiScrollableContent;
import uristqwerty.CraftGuide.client.ui.Rendering.GridRect;

public abstract class GuiScrollableGrid
extends GuiScrollableContent {
    protected int rowHeight;
    private GridRect display;
    private int rows = 0;
    private int columns = 1;
    private int cells = 0;
    private int columnWidth = 1;
    private int reducedWidth = 0;
    public int borderSize = 1;
    public boolean flexibleSize = false;

    public GuiScrollableGrid(int x, int y, int width, int height, GuiScrollBar scrollBar, int rowHeight, int columnWidth) {
        super(x, y, width, height, scrollBar);
        this.display = new GridRect(0, 0, width, height, this);
        this.rowHeight = rowHeight;
        this.columnWidth = columnWidth;
        scrollBar.setAlignmentCallback(this);
        scrollBar.setPageSize(height / rowHeight * rowHeight);
        this.recalculateColumns();
    }

    @Override
    public void draw() {
        int width;
        if (this.flexibleSize && (width = this.columnWidth * ((this.bounds.width() + this.reducedWidth) / this.columnWidth)) != this.bounds.width()) {
            int xOff = this.reducedWidth / 2 & 0xFFFFFFFE;
            this.reducedWidth = this.bounds.width() + this.reducedWidth - width;
            this.setPosition(this.bounds.x() - xOff + (this.reducedWidth / 2 & 0xFFFFFFFE), this.bounds.y());
            this.setSize(width, this.bounds.height());
        }
        if (this.lastScroll != this.scrollBar.getValue()) {
            this.lastScroll = this.scrollBar.getValue();
            this.mouseMoved(this.lastMouseX, this.lastMouseY);
        }
        this.drawBackground();
        this.render(this.display);
        this.drawChildren();
    }

    @Override
    public void drawBackground() {
        if (this.background != null) {
            this.render(this.background, -this.borderSize, -this.borderSize, this.bounds.width() + this.borderSize * 2, this.bounds.height() + this.borderSize * 2);
        }
    }

    @Override
    public void mouseMoved(int x, int y) {
        int gridY = y - this.bounds.y();
        int scrollY = this.pixelsScrolledForY(gridY);
        int row = this.rowAtY(gridY);
        this.mouseMovedRow(row, x - this.bounds.x(), scrollY - this.rowStartPixels(row), this.containsPoint(x, y));
        super.mouseMoved(x, y);
    }

    @Override
    public void mousePressed(int x, int y) {
        int gridY = y - this.bounds.y();
        int row = this.rowAtY(gridY);
        int rowPos = this.pixelsScrolledForY(gridY) - this.rowStartPixels(row);
        this.rowClicked(row, x - this.bounds.x(), rowPos, this.containsPoint(x, y));
        super.mousePressed(x, y);
    }

    protected int rowStartPixels(int row) {
        return row * this.rowHeight;
    }

    protected int pixelsScrolledForScreenY(int y) {
        return (int)this.scrollBar.getValue() + y - this.absoluteY();
    }

    protected int pixelsScrolledForY(int y) {
        return (int)this.scrollBar.getValue() + y;
    }

    protected int rowAtScreenY(int y) {
        return this.pixelsScrolledForScreenY(y) / this.rowHeight;
    }

    protected int rowAtGridY(int y) {
        return y / this.rowHeight;
    }

    protected int rowAtY(int y) {
        return this.pixelsScrolledForY(y) / this.rowHeight;
    }

    protected int getHeightForRow(int row) {
        return this.rowHeight;
    }

    @Override
    public void onResize(int oldWidth, int oldHeight) {
        int width;
        this.scrollBar.setPageSize(this.bounds.height() / this.rowHeight * this.rowHeight);
        this.display.setSize(this.bounds.width(), this.bounds.height());
        if (this.flexibleSize && (width = this.columnWidth * ((this.bounds.width() + this.reducedWidth) / this.columnWidth)) != this.bounds.width()) {
            int xOff = this.reducedWidth / 2;
            this.reducedWidth = this.bounds.width() + this.reducedWidth - width;
            this.setPosition(this.bounds.x() - xOff + this.reducedWidth / 2, this.bounds.y());
            this.setSize(width, this.bounds.height());
        }
        this.recalculateColumns();
        this.scrollBar.setPageSize(this.bounds.height());
    }

    public void recalculateColumns() {
        this.setColumns(Math.max(this.bounds.width() / this.columnWidth, 1));
    }

    public void setRows(int rowCount) {
        this.rows = rowCount;
        this.recalculateRowHeight();
        this.updateScrollbarScale();
    }

    public void updateScrollbarScale() {
        float end = this.rowStartPixels(this.rows - 1) + this.getHeightForRow(this.rows - 1) - this.bounds.height();
        if (end < 0.0f) {
            end = 0.0f;
        }
        this.scrollBar.setRowSize(this.rowHeight);
        this.scrollBar.setScale(0.0f, end);
    }

    protected void recalculateRowHeight() {
        int maxHeight = 1;
        for (int i = 0; i < this.getCells(); ++i) {
            maxHeight = Math.max(maxHeight, this.getMinCellHeight(i));
        }
        this.setRowHeight(maxHeight);
    }

    public void setColumns() {
        this.setColumns(this.bounds.width() / this.columnWidth);
    }

    public void setColumnWidth(int newWidth) {
        this.columnWidth = newWidth;
        this.recalculateColumns();
    }

    public void setRowHeight(int newHeight) {
        this.rowHeight = newHeight;
        this.updateScrollbarScale();
    }

    public void setColumns(int columns) {
        this.columns = columns;
        this.setRows((this.getCells() + columns - 1) / columns);
    }

    protected int getColumns() {
        return this.columns;
    }

    public void setCells(int cells) {
        this.cells = cells;
        this.setRows((cells + this.getColumns() - 1) / this.getColumns());
    }

    protected int getCells() {
        return this.cells;
    }

    public void renderGridRows(GuiRenderer renderer, int xOffset, int yOffset) {
        int y;
        int yMin = this.pixelsScrolledForScreenY(yOffset);
        for (int row = this.rowAtScreenY(yOffset + 1); row < this.rowCount() && (y = this.rowStartPixels(row) - yMin) < this.bounds.height(); ++row) {
            this.renderGridRow(renderer, xOffset, y + yOffset, row);
        }
    }

    public void renderGridRow(GuiRenderer renderer, int xOffset, int yOffset, int row) {
        for (int i = 0; i < this.getColumns(); ++i) {
            int columnX = this.columnOffset(i);
            this.renderGridCell(renderer, xOffset + columnX, yOffset, row * this.getColumns() + i);
        }
    }

    public int columnOffset(int column) {
        if (CraftGuide.gridPacking) {
            return column * this.columnWidth;
        }
        return this.getColumns() < 2 ? 0 : (int)((float)((this.bounds.width() - this.columnWidth) * column) / (float)(this.getColumns() - 1));
    }

    protected int columnAtX(int x) {
        if (CraftGuide.gridPacking) {
            return Math.min(x / this.columnWidth, this.getColumns() - 1);
        }
        return x * this.getColumns() / this.bounds.width();
    }

    public void rowClicked(int row, int x, int y, boolean inBounds) {
        int column = this.columnAtX(x);
        int columnX = this.columnOffset(column);
        if (inBounds && x - columnX < this.columnWidth && row * this.getColumns() + column < this.getCells()) {
            this.cellClicked(row * this.getColumns() + column, x - columnX, y);
        }
    }

    public void mouseMovedRow(int row, int x, int y, boolean inBounds) {
        int columnX;
        int column = this.columnAtX(x);
        if (column >= 0 && row * this.getColumns() + column < this.getCells() && x >= (columnX = this.columnOffset(column)) && x - columnX < this.columnWidth) {
            this.mouseMovedCell(row * this.getColumns() + column, x - columnX, y, inBounds);
        }
    }

    public int cellAtCoords(int x, int y) {
        int row = this.rowAtY(y);
        return this.columnAtX(x) + row * this.getColumns();
    }

    public int rowCount() {
        return this.rows;
    }

    public int firstVisibleRow() {
        return this.rowAtScreenY(this.absoluteY());
    }

    public int lastVisibleRow() {
        return this.rowAtScreenY(this.absoluteY() + this.bounds.height() - 1);
    }

    @Override
    public float alignScrollBar(GuiScrollBar guiScrollBar, float oldValue, float newValue) {
        float alignedNewValue = this.rowStartPixels(this.rowAtGridY((int)newValue));
        if (newValue > oldValue && alignedNewValue <= oldValue) {
            alignedNewValue = this.rowStartPixels(this.rowAtGridY((int)newValue) + 1);
        } else if (newValue < oldValue && alignedNewValue >= oldValue) {
            alignedNewValue = this.rowStartPixels(this.rowAtGridY((int)newValue) - 1);
        }
        return alignedNewValue;
    }

    public void mouseMovedCell(int cell, int x, int y, boolean inBounds) {
    }

    public void cellClicked(int cell, int x, int y) {
    }

    public void renderGridCell(GuiRenderer renderer, int x, int y, int cell) {
    }

    protected abstract int getMinCellHeight(int var1);
}

