/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.LinkedList;
import java.util.List;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.ISliderListener;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.texture.Texture;

public class GuiSlider
extends GuiButton {
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int dx;
    private int dy;
    private List<ISliderListener> sliderListeners = new LinkedList<ISliderListener>();

    @Override
    public void mousePressed(int x, int y) {
        super.mousePressed(x, y);
        this.dx = x - this.bounds.x();
        this.dy = y - this.bounds.y();
    }

    @Override
    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.isHeld()) {
            this.updatePosition(x - this.dx, y - this.dy);
            this.sendSliderEvent();
        }
    }

    @Override
    public GuiElement setSize(int width, int height) {
        float x = this.getPosX();
        float y = this.getPosY();
        this.maxX += width - this.bounds.width();
        this.maxY += height - this.bounds.height();
        this.setValue(x, y);
        return super.setSize(this.bounds.width(), this.bounds.height());
    }

    private void sendSliderEvent() {
        for (ISliderListener listener : this.sliderListeners) {
            listener.onSliderMoved(this);
        }
    }

    public void addSliderListener(ISliderListener listener) {
        this.sliderListeners.add(listener);
    }

    private void updatePosition(int x, int y) {
        x = this.clampValue(x, this.minX, this.maxX);
        y = this.clampValue(y, this.minY, this.maxY);
        this.setPosition(x, y);
    }

    public void setValue(float x, float y) {
        this.updatePosition((int)(x * (float)(this.maxX - this.minX)) + this.minX, (int)(y * (float)(this.maxY - this.minY)) + this.minY);
    }

    private int clampValue(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public GuiSlider(int x, int y, int width, int height, int buttonWidth, int buttonHeight, Texture texture, int u, int v) {
        super(x, y, buttonWidth, buttonHeight, texture, u, v);
        this.minX = x;
        this.minY = y;
        this.maxX = this.minX + width - buttonWidth;
        this.maxY = this.minY + height - buttonHeight;
    }

    public float getPosX() {
        return (float)(this.bounds.x() - this.minX) / (float)(this.maxX - this.minX);
    }

    public float getPosY() {
        return (float)(this.bounds.y() - this.minY) / (float)(this.maxY - this.minY);
    }
}

