/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.HashMap;
import java.util.Map;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.IButtonListener;
import uristqwerty.gui_craftguide.components.GuiElement;

public class GuiTabbedDisplay
extends GuiElement
implements IButtonListener {
    private GuiElement currentTab = null;
    private GuiElement changeTab = null;
    private Map<Object, GuiElement> tabMap = new HashMap<Object, GuiElement>();

    public GuiTabbedDisplay(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public GuiTabbedDisplay(int x, int y, int width, int height, Object[][] tabs) {
        this(x, y, width, height);
        for (Object[] tab : tabs) {
            if (!(tab[0] instanceof GuiElement) || !(tab[1] instanceof GuiButton)) continue;
            this.addTab((GuiElement)tab[0], (GuiButton)tab[1]);
        }
    }

    public GuiTabbedDisplay(int x, int y, int width, int height, Object[] tabs) {
        this(x, y, width, height);
        for (int i = 0; i < (tabs.length & 0xFFFFFFFE); i += 2) {
            if (!(tabs[i] instanceof GuiElement) || !(tabs[i + 1] instanceof GuiButton)) continue;
            this.addTab((GuiElement)tabs[i], (GuiButton)tabs[i + 1]);
        }
    }

    public GuiTabbedDisplay addTab(GuiElement tab, GuiButton button) {
        return this.addTab(tab, button, true);
    }

    public GuiTabbedDisplay addTab(GuiElement tab, GuiButton button, boolean addAsChild) {
        button.addButtonListener(this);
        return this.addTab(tab, (GuiElement)button, addAsChild);
    }

    public GuiTabbedDisplay addTab(GuiElement tab, GuiElement key) {
        return this.addTab(tab, key, true);
    }

    public GuiTabbedDisplay addTab(GuiElement tab, GuiElement key, boolean addAsChild) {
        if (addAsChild) {
            this.addElement(key);
        }
        return this.addTab(tab, (Object)key);
    }

    public GuiTabbedDisplay addTab(GuiElement tab, Object key) {
        this.tabMap.put(key, tab);
        if (this.currentTab == null) {
            this.setTab(tab);
        }
        return this;
    }

    @Override
    public void mousePressed(int x, int y) {
        super.mousePressed(x, y);
        if (this.changeTab != null) {
            this.setTab(this.changeTab);
        }
    }

    @Override
    public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
        if (eventType == IButtonListener.Event.PRESS) {
            this.changeTab = this.tabMap.get(button);
        }
    }

    public void openTab(Object key) {
        this.setTab(this.tabMap.get(key));
    }

    private void setTab(GuiElement tab) {
        if (this.currentTab != null) {
            this.currentTab.mouseReleased(0, 0);
            this.removeElement(this.currentTab);
        }
        if (tab != null) {
            this.addElement(tab);
        }
        this.currentTab = tab;
        this.changeTab = null;
    }

    @Override
    public void onResize(int oldWidth, int oldHeight) {
        for (GuiElement element : this.tabMap.values()) {
            if (element == this.currentTab) continue;
            element.onParentResize(oldWidth, oldHeight, this.bounds.width(), this.bounds.height());
        }
        super.onResize(oldWidth, oldHeight);
    }
}

