/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.dump;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.GuiCraftGuide;
import uristqwerty.CraftGuide.Pair;
import uristqwerty.CraftGuide.Recipe;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.itemtype.ItemType;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.rendering.TexturedRect;

public class HTMLExport {
    private static boolean testRequested = false;
    private File directory;
    private BufferedWriter htmlOut;
    private HashMap<Pair<TexturedRect, TexturedRect>, Integer> recipeCSSIndices = new HashMap();
    private int nextRecipeCSSIndex = 0;

    public static void test() {
        testRequested = true;
    }

    public static void maybeTest() {
        if (testRequested) {
            HTMLExport.doTest();
            testRequested = false;
        }
    }

    public static void doTest() {
        Map<ItemType, List<CraftGuideRecipe>> recipes = GuiCraftGuide.getInstance().getRecipeCache().getAllRecipes();
        List<CraftGuideRecipe> tableRecipes = recipes.get(ItemType.getInstance((Object)new ItemStack(Blocks.field_150462_ai)));
        try {
            File dir = new File("CraftGuide-export-test");
            dir.mkdirs();
            HTMLExport html = new HTMLExport(dir);
            Random rnd = new Random();
            for (int i = 0; i < 5; ++i) {
                CraftGuideRecipe recipe = tableRecipes.get(rnd.nextInt(tableRecipes.size()));
                if (!(recipe instanceof Recipe)) continue;
                html.writeRecipe((Recipe)recipe);
            }
            html.finish();
        }
        catch (IOException e) {
            CraftGuideLog.log(e, "Could not output recipe test", true);
        }
        catch (LWJGLException e) {
            CraftGuideLog.log(e, "Could not output recipe test", true);
        }
    }

    public HTMLExport(File dir) throws IOException {
        this.directory = dir;
        this.htmlOut = new BufferedWriter(new FileWriter(new File(dir, "index.html")));
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.htmlOut.write("<!DOCTYPE html><html><head><meta charset='UTF-8'><link href='recipe_export.css' rel='stylesheet'></head><body>\n");
    }

    private void writeFooter() throws IOException {
        this.htmlOut.write("</body></html>");
    }

    private void finish() throws IOException, LWJGLException {
        CraftGuideLog.checkGlError();
        this.writeFooter();
        this.htmlOut.close();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147110_a().func_147609_e();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)mc.field_71443_c, (double)mc.field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2903);
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int guiScale = scaledresolution.func_78325_e();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        BufferedWriter cssOut = new BufferedWriter(new FileWriter(new File(this.directory, "recipe_export.css")));
        cssOut.write(".r{position:relative;top:0px;left:0px}\n");
        CraftGuideLog.checkGlError();
        for (Map.Entry<Pair<TexturedRect, TexturedRect>, Integer> entry : this.recipeCSSIndices.entrySet()) {
            String prefix = "r" + entry.getValue();
            TexturedRect bg = (TexturedRect)entry.getKey().first;
            TexturedRect bgSel = (TexturedRect)entry.getKey().second;
            cssOut.write("." + prefix + "{width:" + bg.width * guiScale + "px;height:" + bg.height * guiScale + "px;background:url('" + prefix + "-bg.png');}\n");
            cssOut.write("." + prefix + ":hover{width:" + bgSel.width * guiScale + "px;height:" + bgSel.height * guiScale + "px;background:url('" + prefix + "-bgh.png');}\n");
            this.renderToImage(bg, new File(this.directory, prefix + "-bg.png"), scaledresolution.func_78325_e());
            this.renderToImage(bgSel, new File(this.directory, prefix + "-bgh.png"), scaledresolution.func_78325_e());
        }
        cssOut.close();
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        mc.func_147110_a().func_147610_a(true);
        CraftGuideLog.checkGlError();
    }

    private void renderToImage(TexturedRect tex, File file, int guiScale) throws IOException, LWJGLException {
        CraftGuideLog.checkGlError();
        int windowHeight = Minecraft.func_71410_x().field_71440_d;
        int width = tex.width * guiScale;
        int height = tex.height * guiScale;
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        GuiRenderer renderer = (GuiRenderer)RendererBase.instance;
        CraftGuideLog.checkGlError();
        tex.render(renderer, -tex.x, -tex.y);
        CraftGuideLog.checkGlError();
        boolean front = false;
        if (front) {
            GL11.glReadBuffer((int)1028);
            Display.swapBuffers();
            CraftGuideLog.checkGlError();
        } else {
            GL11.glReadBuffer((int)1029);
        }
        GL11.glFinish();
        GL11.glReadPixels((int)0, (int)(windowHeight - height), (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        CraftGuideLog.checkGlError();
        BufferedImage frame = new BufferedImage(width, height, 3);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgba = buffer.getInt((x + (height - y - 1) * width) * 4);
                int argb = rgba >>> 8 | (0xFF ^ rgba) << 24;
                frame.setRGB(x, y, argb);
            }
        }
        ImageWriter writer = HTMLExport.findPngWriter();
        FileImageOutputStream output = new FileImageOutputStream(file);
        writer.setOutput(output);
        writer.write(new IIOImage(frame, null, null));
        output.close();
        writer.dispose();
        CraftGuideLog.checkGlError();
    }

    private void writeRecipe(Recipe recipe) throws IOException {
        this.htmlOut.write("<div class='r " + this.recipeCSS(recipe) + "'>");
        Slot[] slots = recipe.getSlotData();
        Object[] items = recipe.getItems();
        for (int i = 0; i < slots.length; ++i) {
            if (!(slots[i] instanceof ItemSlot)) continue;
            ItemSlot slot = (ItemSlot)slots[i];
            ItemStack item = this.slotItem(slot, items[i]);
            String divClasses = (slot.drawBackground ? "slot " : "") + "i " + this.itemCSS(item);
            this.htmlOut.write("<div class='" + divClasses + "' style='top:" + slot.y + "px;left:" + slot.x + "px'></div>");
        }
        this.htmlOut.write("</div>\n");
    }

    private String itemCSS(ItemStack item) {
        return "ni";
    }

    private ItemStack slotItem(ItemSlot slot, Object object) {
        return null;
    }

    private String recipeCSS(Recipe recipe) {
        Pair<TexturedRect, TexturedRect> key = new Pair<TexturedRect, TexturedRect>((TexturedRect)recipe.background, (TexturedRect)recipe.backgroundSelected);
        Integer index = this.recipeCSSIndices.get(key);
        if (index == null) {
            index = this.nextRecipeCSSIndex++;
            this.recipeCSSIndices.put(key, index);
        }
        return "r" + index;
    }

    public static void outputItemIcon(ItemStack stack, File dest) {
        IItemRenderer renderer = MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        boolean renderAsBlock = stack.func_94608_d() == 0 && item instanceof ItemBlock && RenderBlocks.func_147739_a((int)block.func_149645_b());
        IIcon icon = stack.func_77954_c();
        if (renderer != null || renderAsBlock || !(icon instanceof TextureAtlasSprite) || ((TextureAtlasSprite)icon).func_110970_k() > 1) {
            // empty if block
        }
    }

    private static ImageWriter findGifWriter() {
        Iterator<ImageWriter> i = ImageIO.getImageWritersByFormatName("gif");
        while (i.hasNext()) {
            ImageWriter w = i.next();
            if (!w.canWriteSequence()) continue;
            return w;
        }
        return null;
    }

    private static ImageWriter findPngWriter() {
        Iterator<ImageWriter> i = ImageIO.getImageWritersByFormatName("png");
        if (i.hasNext()) {
            ImageWriter w = i.next();
            return w;
        }
        return null;
    }
}

