/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.api.CombinableItemFilter;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.LiquidFilter;
import uristqwerty.CraftGuide.api.PseudoFluidFilter;
import uristqwerty.CraftGuide.api.PseudoFluidStack;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.filters.MultipleItemFilter;
import uristqwerty.CraftGuide.filters.SingleItemFilter;
import uristqwerty.CraftGuide.filters.StringItemFilter;

public class MultiFilter
implements CombinableItemFilter {
    private CombinableItemFilter items = new MultipleItemFilter(new ArrayList<ItemStack>());
    private ArrayList<String> strings = new ArrayList();
    private ArrayList<FluidStack> liquids = new ArrayList();
    private ArrayList<PseudoFluidStack> pseudoLiquids = new ArrayList();

    public MultiFilter(CombinableItemFilter items) {
        this.addItemFilter(items);
    }

    @Override
    public boolean matches(Object item) {
        if (this.items != null && this.items.matches(item)) {
            return true;
        }
        for (String string : this.strings) {
            if (!MultiFilter.stringMatch(string, item)) continue;
            return true;
        }
        for (FluidStack fluidStack : this.liquids) {
            if (!MultiFilter.liquidMatch(fluidStack, item)) continue;
            return true;
        }
        for (PseudoFluidStack pseudoFluidStack : this.pseudoLiquids) {
            if (!MultiFilter.liquidMatch(pseudoFluidStack, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        this.items.draw(renderer, x, y);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        for (String string : this.strings) {
            tooltip.add("Text: \"" + string + "\"");
        }
        for (FluidStack fluidStack : this.liquids) {
            tooltip.add("Liquid: \"" + fluidStack.getLocalizedName() + "\"");
        }
        for (PseudoFluidStack pseudoFluidStack : this.pseudoLiquids) {
            tooltip.add("Liquid: \"" + pseudoFluidStack.getLocalizedName() + "\"");
        }
        tooltip.addAll(this.items.getTooltip());
        return tooltip;
    }

    @Override
    public ItemFilter addItemFilter(ItemFilter other) {
        if (other instanceof SingleItemFilter || other instanceof MultipleItemFilter) {
            ItemFilter filter = this.items.addItemFilter(other);
            if (filter instanceof CombinableItemFilter) {
                this.items = (CombinableItemFilter)filter;
            }
        } else if (other instanceof StringItemFilter) {
            this.addString(((StringItemFilter)other).comparison);
        } else if (other instanceof LiquidFilter) {
            FluidStack stack = ((LiquidFilter)other).liquid;
            for (FluidStack s : this.liquids) {
                if (!s.isFluidEqual(stack)) continue;
                return this;
            }
            this.liquids.add(stack);
        } else if (other instanceof PseudoFluidFilter) {
            PseudoFluidStack stack = ((PseudoFluidFilter)other).liquid;
            for (PseudoFluidStack s : this.pseudoLiquids) {
                if (!s.isFluidEqual(stack)) continue;
                return this;
            }
            this.pseudoLiquids.add(stack);
        }
        return this;
    }

    private void addString(String comparison) {
        comparison = comparison.toLowerCase();
        for (String s : this.strings) {
            if (!comparison.equals(s)) continue;
            return;
        }
        this.strings.add(comparison);
    }

    @Override
    public ItemFilter subtractItemFilter(ItemFilter other) {
        if (other instanceof SingleItemFilter || other instanceof MultipleItemFilter) {
            ItemFilter filter = this.items.subtractItemFilter(other);
            if (filter instanceof CombinableItemFilter) {
                this.items = (CombinableItemFilter)filter;
            } else if (filter != null) {
                this.items = new MultipleItemFilter(new ArrayList<ItemStack>());
            }
        } else if (other instanceof StringItemFilter) {
            String str = ((StringItemFilter)other).comparison;
            Iterator<String> iter = this.strings.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(str)) continue;
                iter.remove();
            }
            if (this.liquids.isEmpty() && this.pseudoLiquids.isEmpty() && this.strings.isEmpty()) {
                return this.items;
            }
        } else if (other instanceof LiquidFilter) {
            FluidStack stack = ((LiquidFilter)other).liquid;
            Iterator<FluidStack> iter = this.liquids.iterator();
            while (iter.hasNext()) {
                if (!iter.next().isFluidEqual(stack)) continue;
                iter.remove();
            }
            if (this.liquids.isEmpty() && this.pseudoLiquids.isEmpty() && this.strings.isEmpty()) {
                return this.items;
            }
        } else if (other instanceof PseudoFluidFilter) {
            PseudoFluidStack stack = ((PseudoFluidFilter)other).liquid;
            Iterator<PseudoFluidStack> iter = this.pseudoLiquids.iterator();
            while (iter.hasNext()) {
                if (!iter.next().isFluidEqual(stack)) continue;
                iter.remove();
            }
            if (this.liquids.isEmpty() && this.pseudoLiquids.isEmpty() && this.strings.isEmpty()) {
                return this.items;
            }
        }
        return this;
    }

    @Override
    public List<ItemStack> getRepresentativeItems() {
        return this.items.getRepresentativeItems();
    }

    private static boolean stringMatch(String comparison, Object item) {
        if (item instanceof ItemStack) {
            try {
                return CommonUtilities.searchExtendedItemStackText(item, comparison);
            }
            catch (Throwable e) {
                CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.StringItemFilter.matches ItemStack branch");
                throw new RuntimeException(e);
            }
        }
        if (item instanceof String) {
            try {
                return ((String)item).toLowerCase().contains(comparison);
            }
            catch (Throwable e) {
                CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.StringItemFilter.matches String branch");
                throw new RuntimeException(e);
            }
        }
        if (item instanceof FluidStack) {
            return ((FluidStack)item).getLocalizedName().toLowerCase().contains(comparison);
        }
        if (item instanceof PseudoFluidStack) {
            return ((PseudoFluidStack)item).getLocalizedName().toLowerCase().contains(comparison);
        }
        if (item instanceof List) {
            try {
                List<String> lines;
                List list = (List)item;
                for (Object o : list) {
                    if (!MultiFilter.stringMatch(comparison, o)) continue;
                    return true;
                }
                if (list.size() < 1 && (lines = ForgeExtensions.emptyOreDictEntryText(list)) != null) {
                    for (String line : lines) {
                        if (line == null || !line.toLowerCase().contains(comparison)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (Throwable e) {
                CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.StringItemFilter.matches List branch");
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private static boolean liquidMatch(FluidStack liquid, Object item) {
        if (item instanceof ItemStack) {
            ItemStack stack = (ItemStack)item;
            if (stack.func_77973_b() != null) {
                return liquid.isFluidEqual(stack);
            }
        } else {
            if (item instanceof FluidStack) {
                return liquid.isFluidEqual((FluidStack)item);
            }
            if (item instanceof String) {
                return liquid.getLocalizedName().toLowerCase().contains(((String)item).toLowerCase());
            }
            if (item instanceof List) {
                for (Object object : (List)item) {
                    if (!MultiFilter.liquidMatch(liquid, object)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean liquidMatch(PseudoFluidStack liquid, Object item) {
        if (item instanceof PseudoFluidStack) {
            return liquid.isFluidEqual((PseudoFluidStack)item);
        }
        if (item instanceof String) {
            return liquid.getLocalizedName().toLowerCase().contains(((String)item).toLowerCase());
        }
        if (item instanceof List) {
            for (Object object : (List)item) {
                if (!MultiFilter.liquidMatch(liquid, object)) continue;
                return true;
            }
        }
        return false;
    }
}

