/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.itemtype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import uristqwerty.CraftGuide.CommonUtilities;

public class ItemType
implements Comparable<ItemType> {
    private static final ItemTypeKey errKey = new ItemTypeKey(Integer.MAX_VALUE, Integer.MIN_VALUE);
    private static final ItemType errType_nullItem = new ItemType(errKey, "Error\nOne or more recipe contains an ItemStack with a null item.");
    private static final ItemType errType_unknownType = new ItemType(errKey, "Error\nItemType requested for unknown type of item.");
    private static Map<ItemTypeKey, ItemType> simpleItemStacks = new HashMap<ItemTypeKey, ItemType>();
    private static Map<ItemTypeKey, List<ItemType>> nbtItemStacks = new HashMap<ItemTypeKey, List<ItemType>>();
    private static Map<String, ItemType> oreDictionaryEntries = new HashMap<String, ItemType>();
    private static Map<ArrayList<ItemStack>, ItemType> generalArrayLists = new IdentityHashMap<ArrayList<ItemStack>, ItemType>();
    private final ItemTypeKey key;
    private final Item item;
    private final Object stack;
    private final int originalHashcode;

    private ItemType(Item item, int itemDamage) {
        this.item = item;
        this.key = new ItemTypeKey(Item.func_150891_b((Item)item), itemDamage);
        this.stack = new ItemStack(item, 1, itemDamage);
        this.originalHashcode = 0;
    }

    private ItemType(ItemTypeKey key) {
        this.item = Item.func_150899_d((int)key.id);
        this.key = key;
        this.stack = new ItemStack(this.item, 1, key.damage);
        this.originalHashcode = 0;
    }

    private ItemType(ArrayList<ItemStack> items) {
        ItemStack itemStack = items.get(0);
        this.item = itemStack.func_77973_b();
        this.key = new ItemTypeKey(Item.func_150891_b((Item)this.item), CommonUtilities.getItemDamage(itemStack));
        this.stack = items;
        this.originalHashcode = items.hashCode();
    }

    private ItemType(ItemTypeKey key, NBTTagCompound nbt, int nbtHash) {
        this.item = Item.func_150899_d((int)key.id);
        this.key = key;
        ItemStack stack = new ItemStack(this.item, 1, key.damage);
        stack.func_77982_d((NBTTagCompound)nbt.func_74737_b());
        this.stack = stack;
        this.originalHashcode = nbtHash;
    }

    private ItemType(ItemTypeKey key, String msg) {
        this.item = null;
        this.key = key;
        this.stack = msg;
        this.originalHashcode = msg.hashCode();
    }

    public static ItemType getInstance(Object stack) {
        if (stack instanceof ItemStack) {
            return ItemType.getInstance((ItemStack)stack);
        }
        if (stack instanceof ArrayList && ((ArrayList)stack).size() > 0) {
            for (Object o : (ArrayList)stack) {
                if (o == null || o instanceof ItemStack) continue;
                return errType_unknownType;
            }
            return ItemType.getInstance((ArrayList)stack);
        }
        return errType_unknownType;
    }

    private static ItemType getInstance(ArrayList<ItemStack> stack) {
        ItemType type = generalArrayLists.get(stack);
        if (type == null) {
            type = new ItemType(stack);
            generalArrayLists.put(stack, type);
        }
        return type;
    }

    private static ItemType getInstance(ItemStack stack) {
        ItemType type;
        if (stack.func_77973_b() == null) {
            return errType_nullItem;
        }
        ItemTypeKey key = new ItemTypeKey(stack);
        if (!stack.func_77942_o()) {
            type = simpleItemStacks.get(key);
            if (type == null) {
                type = new ItemType(key);
                simpleItemStacks.put(key, type);
            }
        } else {
            int nbtHash;
            NBTTagCompound nbt;
            List<ItemType> items = nbtItemStacks.get(key);
            if (items == null) {
                items = new ArrayList<ItemType>();
                nbtItemStacks.put(key, items);
            }
            if ((type = ItemType.findMatchingNBT(items, nbt = stack.func_77978_p(), nbtHash = nbt.hashCode())) == null) {
                nbt = (NBTTagCompound)nbt.func_74737_b();
                type = new ItemType(key, nbt, nbtHash);
                items.add(type);
            }
        }
        return type;
    }

    private static ItemType findMatchingNBT(List<ItemType> items, NBTTagCompound nbt) {
        return ItemType.findMatchingNBT(items, nbt, nbt.hashCode());
    }

    private static ItemType findMatchingNBT(List<ItemType> items, NBTTagCompound nbt, int nbtHash) {
        for (ItemType type : items) {
            ItemStack stack = (ItemStack)type.stack;
            if (type.originalHashcode != nbtHash || !nbt.equals((Object)stack.func_77978_p())) continue;
            return type;
        }
        return null;
    }

    public static boolean hasInstance(ItemStack stack) {
        ItemTypeKey key = new ItemTypeKey(stack);
        if (!stack.func_77942_o()) {
            return simpleItemStacks.containsKey(key);
        }
        List<ItemType> items = nbtItemStacks.get(key);
        if (items == null) {
            return false;
        }
        return ItemType.findMatchingNBT(items, stack.func_77978_p()) != null;
    }

    @Override
    public int compareTo(ItemType other) {
        int keySort = this.key.compareTo(other.key);
        if (keySort != 0) {
            return keySort;
        }
        if (this.stack instanceof ArrayList != other.stack instanceof ArrayList) {
            return this.stack instanceof ArrayList ? -1 : 1;
        }
        if (this.stack instanceof String != other.stack instanceof String) {
            return other.stack instanceof String ? -1 : 1;
        }
        if (this.stack instanceof ItemStack) {
            ItemStack thisStack = (ItemStack)this.stack;
            ItemStack otherStack = (ItemStack)other.stack;
            if (thisStack.func_77942_o() != otherStack.func_77942_o()) {
                return thisStack.func_77942_o() ? -1 : 1;
            }
            if (thisStack.func_77942_o()) {
                return this.compareInts(this.hashCode(), other.hashCode());
            }
        } else {
            if (this.stack instanceof String) {
                String thisStack = (String)this.stack;
                String otherStack = (String)other.stack;
                return thisStack.compareTo(otherStack);
            }
            return this.compareInts(this.hashCode(), other.hashCode());
        }
        return 0;
    }

    private int compareInts(int a, int b) {
        return Integer.signum(a - b);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ItemType)) {
            return super.equals(obj);
        }
        ItemType other = (ItemType)obj;
        if (this.stack instanceof ItemStack && other.stack instanceof ItemStack) {
            if (!this.key.equals(other.key)) {
                return false;
            }
            ItemStack thisStack = (ItemStack)this.stack;
            ItemStack otherStack = (ItemStack)other.stack;
            if (thisStack.func_77942_o() != otherStack.func_77942_o()) {
                return false;
            }
            if (!thisStack.func_77942_o()) {
                return true;
            }
            return thisStack.func_77978_p().equals((Object)otherStack.func_77978_p());
        }
        if (this.stack instanceof ArrayList && other.stack instanceof ArrayList) {
            return this.stack.equals(other.stack);
        }
        if (this.stack instanceof String && other.stack instanceof String) {
            return this.stack.equals(other.stack);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.originalHashcode;
    }

    public Object getStack() {
        return this.stack;
    }

    public ItemStack getDisplayStack() {
        if (this.stack instanceof ItemStack) {
            return (ItemStack)this.stack;
        }
        if (this.stack instanceof ArrayList) {
            return (ItemStack)((ArrayList)this.stack).get(0);
        }
        return null;
    }

    private static final class ItemTypeKey
    implements Comparable<ItemTypeKey> {
        public final int id;
        public final int damage;

        public ItemTypeKey(ItemStack stack) {
            this(stack.func_77973_b(), stack.func_77960_j());
        }

        public ItemTypeKey(Item item, int damage) {
            this(Item.func_150891_b((Item)item), damage);
        }

        public ItemTypeKey(int id, int damage) {
            this.id = id;
            this.damage = damage;
        }

        public int hashCode() {
            int prime = 104147;
            int result = 1;
            result = 104147 * result + this.damage;
            result = 104147 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemTypeKey other = (ItemTypeKey)obj;
            return this.id == other.id && this.damage == other.damage;
        }

        @Override
        public int compareTo(ItemTypeKey other) {
            if (this.id != other.id) {
                return this.id > other.id ? 1 : -1;
            }
            return this.damage == other.damage ? 0 : (this.damage > other.damage ? 1 : -1);
        }
    }
}

