/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;
import uristqwerty.CraftGuide.api.CraftGuideAPIObject;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.StackInfo;
import uristqwerty.CraftGuide.api.StackInfoSource;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class DefaultRecipeProvider
extends CraftGuideAPIObject
implements RecipeProvider,
StackInfoSource {
    private final Slot[] shapelessCraftingSlots = new ItemSlot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private final Slot[] craftingSlotsOwnBackground = new ItemSlot[]{new ItemSlot(3, 3, 16, 16).drawOwnBackground(), new ItemSlot(21, 3, 16, 16).drawOwnBackground(), new ItemSlot(39, 3, 16, 16).drawOwnBackground(), new ItemSlot(3, 21, 16, 16).drawOwnBackground(), new ItemSlot(21, 21, 16, 16).drawOwnBackground(), new ItemSlot(39, 21, 16, 16).drawOwnBackground(), new ItemSlot(3, 39, 16, 16).drawOwnBackground(), new ItemSlot(21, 39, 16, 16).drawOwnBackground(), new ItemSlot(39, 39, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
    private final Slot[] smallCraftingSlotsOwnBackground = new ItemSlot[]{new ItemSlot(12, 12, 16, 16).drawOwnBackground(), new ItemSlot(30, 12, 16, 16).drawOwnBackground(), new ItemSlot(12, 30, 16, 16).drawOwnBackground(), new ItemSlot(30, 30, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
    private final Slot[] craftingSlots = new ItemSlot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private final Slot[] smallCraftingSlots = new ItemSlot[]{new ItemSlot(12, 12, 16, 16), new ItemSlot(30, 12, 16, 16), new ItemSlot(12, 30, 16, 16), new ItemSlot(30, 30, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private final Slot[] furnaceSlots = new ItemSlot[]{new ItemSlot(13, 21, 16, 16), new ItemSlot(50, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};

    public DefaultRecipeProvider() {
        StackInfo.addSource(this);
    }

    @Override
    public void generateRecipes(RecipeGenerator generator) {
        RecipeTemplate smallCraftingTemplate;
        RecipeTemplate craftingTemplate;
        if (CraftGuide.newerBackgroundStyle) {
            craftingTemplate = generator.createRecipeTemplate(this.craftingSlotsOwnBackground, null);
            smallCraftingTemplate = generator.createRecipeTemplate(this.smallCraftingSlotsOwnBackground, null);
        } else {
            craftingTemplate = new DefaultRecipeTemplate(this.craftingSlots, RecipeGeneratorImplementation.workbench, new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 1, 1, 79, 58), new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 82, 1, 79, 58));
            smallCraftingTemplate = new DefaultRecipeTemplate(this.smallCraftingSlots, RecipeGeneratorImplementation.workbench, new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 1, 61, 79, 58), new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 82, 61, 79, 58));
        }
        DefaultRecipeTemplate shapelessTemplate = new DefaultRecipeTemplate(this.shapelessCraftingSlots, RecipeGeneratorImplementation.workbench, new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 1, 121, 79, 58), new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 82, 121, 79, 58));
        DefaultRecipeTemplate furnaceTemplate = new DefaultRecipeTemplate(this.furnaceSlots, new ItemStack(Blocks.field_150460_al), new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 1, 181, 79, 58), new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 82, 181, 79, 58));
        this.addCraftingRecipes(craftingTemplate, smallCraftingTemplate, shapelessTemplate, generator);
        this.addFurnaceRecipes(furnaceTemplate, generator);
    }

    private void addFurnaceRecipes(RecipeTemplate template, RecipeGenerator generator) {
        Map furnaceRecipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry entry : furnaceRecipes.entrySet()) {
            ItemStack input = (ItemStack)entry.getKey();
            if (input.func_77960_j() == Short.MAX_VALUE && input.func_77973_b().func_77614_k()) {
                ArrayList items = new ArrayList();
                input.func_77973_b().func_150895_a(input.func_77973_b(), null, items);
                for (ItemStack subItem : items) {
                    generator.addRecipe(template, new Object[]{subItem, entry.getValue()});
                }
                continue;
            }
            generator.addRecipe(template, new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    private void addCraftingRecipes(RecipeTemplate template, RecipeTemplate templateSmall, RecipeTemplate templateShapeless, RecipeGenerator generator) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        int errCount = 0;
        for (Object o : recipes) {
            try {
                IRecipe recipe = (IRecipe)o;
                Object[] items = generator.getCraftingRecipe(recipe, true);
                if (items == null) continue;
                if (items.length == 5) {
                    generator.addRecipe(templateSmall, items);
                    continue;
                }
                if (this.isShapelessRecipe(recipe)) {
                    generator.addRecipe(templateShapeless, items);
                    continue;
                }
                generator.addRecipe(template, items);
            }
            catch (Exception e) {
                if (errCount != -1) {
                    if (errCount++ >= 5) {
                        CraftGuideLog.log("CraftGuide DefaultRecipeProvider: Stack trace limit reached, further stack traces from this invocation will not be logged to the console. They will still be logged to (.minecraft)/config/CraftGuide/CraftGuide.log", true);
                        errCount = -1;
                    } else {
                        e.printStackTrace();
                    }
                }
                CraftGuideLog.log(e);
            }
        }
    }

    private boolean isShapelessRecipe(IRecipe recipe) {
        return recipe instanceof ShapelessRecipes || ForgeExtensions.isShapelessRecipe(recipe);
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        int fuel = TileEntityFurnace.func_145952_a((ItemStack)itemStack);
        if (fuel > 0) {
            double value = (double)fuel / 200.0;
            int round = (int)value;
            int dec = (int)((value - (double)round) * 100.0);
            StringBuilder builder = new StringBuilder("\u00a77Can fuel ");
            builder.append(round);
            if (dec > 0) {
                builder.append('.');
                if (dec < 10) {
                    builder.append('0');
                }
                builder.append(dec);
            }
            builder.append(" furnace operations");
            return builder.toString();
        }
        return null;
    }
}

