/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.components;

import java.util.EnumMap;
import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.editor.GuiElementMeta;
import uristqwerty.gui_craftguide.texture.Texture;

@GuiElementMeta(name="button")
public class Button
extends GuiElement {
    @GuiElementMeta.GuiElementProperty(name="states")
    @GuiElementMeta.EnumMapProperty(keyType=ButtonState.class, valueType=Texture.class)
    public EnumMap<ButtonState, Texture> stateBackgrounds = new EnumMap(ButtonState.class);
    private ButtonState currentState;

    public Button(int x, int y, int width, int height) {
        this(new Rect(x, y, width, height));
    }

    public Button(int x, int y, int width, int height, String template) {
        this(new Rect(x, y, width, height), template);
    }

    public Button(Rect rect) {
        this(rect, "button-default");
    }

    public Button(Rect rect, String template) {
        super(rect, template);
    }

    @Override
    public void mouseMoved(int x, int y) {
        if (this.containsPoint(x, y)) {
            if (this.currentState == ButtonState.UP) {
                this.currentState = ButtonState.MOUSEOVER;
            } else if (this.currentState == ButtonState.DOWN_MOUSEOUT) {
                this.currentState = ButtonState.DOWN;
            }
        } else if (this.currentState == ButtonState.MOUSEOVER) {
            this.currentState = ButtonState.UP;
        } else if (this.currentState == ButtonState.DOWN) {
            this.currentState = ButtonState.DOWN_MOUSEOUT;
        }
        super.mouseMoved(x, y);
    }

    @Override
    public void mouseReleased(int x, int y) {
        this.currentState = ButtonState.UP;
        super.mouseReleased(x, y);
    }

    @Override
    public void drawBackground() {
        super.drawBackground();
        Texture texture = this.stateBackgrounds.get((Object)this.currentState);
        if (texture != null) {
            this.render(texture, 0, 0, this.bounds.width(), this.bounds.height());
        }
    }

    static enum ButtonState {
        UP,
        DOWN,
        MOUSEOVER,
        DOWN_MOUSEOUT;

    }
}

