/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.editor;

import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.Texture;

public class TextureDisplay
extends GuiElement
implements Renderable {
    private Texture currentTexture;
    private Rect textureSize;

    public TextureDisplay(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.textureSize = this.bounds.rect();
    }

    public TextureDisplay(Rect rect) {
        super(rect);
        this.textureSize = rect;
    }

    @Override
    public void draw() {
        this.render(this);
        super.draw();
    }

    public void setTexture(Texture texture, Rect size) {
        this.currentTexture = texture;
        this.textureSize = size;
    }

    @Override
    public void render(RendererBase renderer, int x, int y) {
        if (this.currentTexture != null && this.textureSize != null) {
            renderer.setAlpha(127);
            renderer.drawTexturedRect(this.currentTexture, x, y, this.bounds.width(), this.bounds.height(), (this.textureSize.width - this.bounds.width()) / 2, (this.textureSize.height - this.bounds.height()) / 2);
            renderer.setAlpha(256);
            renderer.drawTexturedRect(this.currentTexture, x + (this.bounds.width() - this.textureSize.width) / 2, y + (this.bounds.height() - this.textureSize.height) / 2, this.textureSize.width, this.textureSize.height, 0, 0);
        }
    }
}

