/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.minecraft;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.RendererBase;

public class MultilineText
implements Renderable {
    protected int x;
    protected int y;
    protected String[] text;
    protected int color;
    protected int lineSpacing;

    public MultilineText(int x, int y, String[] text, int lineSpacing, int color) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.color = color;
        this.lineSpacing = lineSpacing;
    }

    public MultilineText(int x, int y, String[] text, int lineSpacing) {
        this(x, y, text, lineSpacing, -16777216);
    }

    public MultilineText(int x, int y, String[] text) {
        this(x, y, text, 10, -16777216);
    }

    @Override
    public void render(RendererBase renderer, int x, int y) {
        renderer.setColor(this.color);
        int lineY = 0;
        for (String line : this.text) {
            renderer.drawText(line, x + this.x, y + this.y + lineY);
            lineY += this.lineSpacing;
        }
        renderer.setColor(-1);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setText(String[] text) {
        this.text = text;
    }

    public int textHeight() {
        return 8;
    }

    public int textWidth() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int width = 0;
        for (String line : this.text) {
            width = Math.max(width, fontRenderer.func_78256_a(line));
        }
        return width;
    }
}

