/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.rendering;

import org.lwjgl.opengl.GL11;
import uristqwerty.gui_craftguide.Color;
import uristqwerty.gui_craftguide.texture.Texture;

public abstract class RendererBase {
    protected double red;
    protected double green;
    protected double blue;
    protected double alpha;
    protected double redModifier;
    protected double greenModifier;
    protected double blueModifier;
    protected double alphaModifier;
    public static RendererBase instance;

    public abstract double getClock();

    public abstract void setTextureID(int var1);

    public abstract void drawText(String var1, int var2, int var3);

    public abstract void drawTextWithShadow(String var1, int var2, int var3);

    public void resetValues() {
        this.red = 1.0;
        this.green = 1.0;
        this.blue = 1.0;
        this.alpha = 1.0;
        this.redModifier = 1.0;
        this.greenModifier = 1.0;
        this.blueModifier = 1.0;
        this.alphaModifier = 1.0;
    }

    public void drawRect(int x, int y, int width, int height) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.setGlColor(this.red, this.green, this.blue, this.alpha);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }

    public void drawTexturedRect(int x, int y, int width, int height, double u, double v, double u2, double v2) {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.setGlColor(this.red, this.green, this.blue, this.alpha);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2d((double)u, (double)v2);
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glTexCoord2d((double)u2, (double)v2);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glTexCoord2d((double)u2, (double)v);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glEnd();
        GL11.glDisable((int)3042);
    }

    public void drawTexturedRect(Texture texture, int x, int y, int width, int height, int u, int v) {
        texture.renderRect(this, x, y, width, height, u, v);
    }

    public void setColorModifier(double red, double green, double blue, double alpha) {
        this.redModifier = red;
        this.greenModifier = green;
        this.blueModifier = blue;
        this.alphaModifier = alpha;
    }

    public void setColorModifierv(double[] v) {
        this.redModifier = v[0];
        this.greenModifier = v[1];
        this.blueModifier = v[2];
        this.alphaModifier = v[3];
    }

    public void setColorModifierv(Color color) {
        this.redModifier = (double)color.red / 255.0;
        this.greenModifier = (double)color.green / 255.0;
        this.blueModifier = (double)color.blue / 255.0;
        this.alphaModifier = (double)color.alpha / 255.0;
    }

    public void getColorModifierv(double[] v) {
        v[0] = this.red;
        v[1] = this.green;
        v[2] = this.blue;
        v[3] = this.alpha;
    }

    public void setColorRgb(int colour) {
        this.setColor(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public void setColor(int color) {
        this.setColor(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue);
        this.setAlpha(alpha);
    }

    public void setColor(int red, int green, int blue) {
        this.red = (double)red / 255.0;
        this.green = (double)green / 255.0;
        this.blue = (double)blue / 255.0;
    }

    public void setAlpha(int alpha) {
        this.alpha = (double)alpha / 255.0;
    }

    public void setGlColor(double red, double green, double blue, double alpha) {
        GL11.glColor4d((double)(red * this.redModifier), (double)(green * this.greenModifier), (double)(blue * this.blueModifier), (double)(alpha * this.alphaModifier));
    }
}

