/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.rendering;

import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.Texture;

public class TexturedRect
implements Renderable {
    public int x;
    public int y;
    public int width;
    public int height;
    public int u;
    public int v;
    public Texture texture;

    public TexturedRect(int x, int y, int width, int height, Texture texture) {
        this(x, y, width, height, texture, 0, 0);
    }

    public TexturedRect(int x, int y, int width, int height, Texture texture, int u, int v) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.texture = texture;
        this.u = u;
        this.v = v;
    }

    @Override
    public void render(RendererBase renderer, int x, int y) {
        renderer.drawTexturedRect(this.texture, x + this.x, y + this.y, this.width, this.height, this.u, this.v);
    }

    public void moveBy(int xChange, int yChange) {
        this.x += xChange;
        this.y += yChange;
    }

    public void resizeBy(int widthChange, int heightChange) {
        this.width += widthChange;
        this.height += heightChange;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TexturedRect other = (TexturedRect)obj;
        return this.texture.equals(other.texture) && this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height && this.u == other.u && this.v == other.v;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

