/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.texture;

import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.SubTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.texture.TextureClip;

@TextureMeta(name="borderedtexture")
public class BorderedTexture
implements Texture {
    @TextureMeta.ListSize(value=9)
    @TextureMeta.TextureParameter
    public Texture[] textures = new Texture[9];
    @TextureMeta.TextureParameter
    public int borderWidth;
    @TextureMeta.TextureParameter
    public int borderHeight;

    public BorderedTexture() {
    }

    public BorderedTexture(Texture[] textures, int borderWidth) {
        this(textures, borderWidth, borderWidth);
    }

    public BorderedTexture(Texture[] textures, int borderWidth, int borderHeight) {
        for (int i = 0; i < Math.min(textures.length, 9); ++i) {
            this.textures[i] = textures[i];
        }
        this.borderWidth = borderWidth;
        this.borderHeight = borderHeight;
    }

    public BorderedTexture(Texture source, int u, int v, int spacing, int centerSize, int borderSize) {
        this(source, u, v, spacing, centerSize, centerSize, borderSize, borderSize);
    }

    public BorderedTexture(Texture source, int u, int v, int spacing, int centerWidth, int centerHeight, int borderWidth, int borderHeight) {
        int centerU = u + spacing + borderWidth;
        int rightU = u + spacing * 2 + centerWidth + borderWidth;
        int centerV = v + spacing + borderHeight;
        int bottomV = v + spacing * 2 + centerHeight + borderHeight;
        this.textures[0] = new TextureClip(source, u, v, borderWidth, borderHeight);
        this.textures[1] = new SubTexture(source, centerU, v, centerWidth, borderHeight);
        this.textures[2] = new TextureClip(source, rightU, v, borderWidth, borderHeight);
        this.textures[3] = new TextureClip(source, u, centerV, borderWidth, centerHeight);
        this.textures[4] = new SubTexture(source, centerU, centerV, centerWidth, centerHeight);
        this.textures[5] = new TextureClip(source, rightU, centerV, borderWidth, centerHeight);
        this.textures[6] = new TextureClip(source, u, bottomV, borderWidth, borderHeight);
        this.textures[7] = new SubTexture(source, centerU, bottomV, centerWidth, borderHeight);
        this.textures[8] = new TextureClip(source, rightU, bottomV, borderWidth, borderHeight);
        this.borderWidth = borderWidth;
        this.borderHeight = borderHeight;
    }

    @Override
    public void renderRect(RendererBase renderer, int x, int y, int width, int height, int u, int v) {
        this.textures[0].renderRect(renderer, x, y, this.borderWidth, this.borderHeight, 0, 0);
        this.textures[1].renderRect(renderer, x + this.borderWidth, y, width - this.borderWidth * 2, this.borderHeight, 0, 0);
        this.textures[2].renderRect(renderer, x + width - this.borderWidth, y, this.borderWidth, this.borderHeight, 0, 0);
        this.textures[3].renderRect(renderer, x, y + this.borderHeight, this.borderWidth, height - this.borderHeight * 2, 0, 0);
        this.textures[4].renderRect(renderer, x + this.borderWidth, y + this.borderHeight, width - this.borderWidth * 2, height - this.borderHeight * 2, 0, 0);
        this.textures[5].renderRect(renderer, x + width - this.borderWidth, y + this.borderHeight, this.borderWidth, height - this.borderHeight * 2, 0, 0);
        this.textures[6].renderRect(renderer, x, y + height - this.borderHeight, this.borderWidth, this.borderHeight, 0, 0);
        this.textures[7].renderRect(renderer, x + this.borderWidth, y + height - this.borderHeight, width - this.borderWidth * 2, this.borderHeight, 0, 0);
        this.textures[8].renderRect(renderer, x + width - this.borderWidth, y + height - this.borderHeight, this.borderWidth, this.borderHeight, 0, 0);
    }
}

