/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import org.xml.sax.Attributes;
import uristqwerty.gui_craftguide.Color;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.reader.ElementHandler;
import uristqwerty.gui_craftguide.theme.reader.NullElement;
import uristqwerty.gui_craftguide.theme.reader.ValueTemplate;

public class ColorTemplate
implements ValueTemplate {
    public int red = 255;
    public int green = 255;
    public int blue = 255;
    public int alpha = 255;
    private final TextureMeta.WithUnits units;

    public ColorTemplate(TextureMeta.WithUnits units) {
        this.units = units;
    }

    @Override
    public void startElement(Theme theme, String name, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getLocalName(i).equalsIgnoreCase("red")) {
                this.red = this.num(attributes.getValue(i));
                continue;
            }
            if (attributes.getLocalName(i).equalsIgnoreCase("green")) {
                this.green = this.num(attributes.getValue(i));
                continue;
            }
            if (attributes.getLocalName(i).equalsIgnoreCase("blue")) {
                this.blue = this.num(attributes.getValue(i));
                continue;
            }
            if (!attributes.getLocalName(i).equalsIgnoreCase("alpha")) continue;
            this.alpha = this.num(attributes.getValue(i));
        }
    }

    @Override
    public void characters(Theme theme, char[] chars, int start, int length) {
    }

    @Override
    public ElementHandler getSubElement(String name, Attributes attributes) {
        return NullElement.instance;
    }

    @Override
    public void endElement(Theme theme, String name) {
    }

    @Override
    public void endSubElement(Theme theme, ElementHandler handler, String name) {
    }

    private int num(String str) {
        double multiplier = 1.0;
        if (this.units != null) {
            String lower = str.toLowerCase();
            int longestMatch = 0;
            for (TextureMeta.Unit u : this.units.value()) {
                for (String unitName : u.names()) {
                    if (!lower.endsWith(unitName.toLowerCase()) || unitName.length() <= longestMatch) continue;
                    multiplier = u.multiplier();
                    longestMatch = unitName.length();
                }
            }
            if (longestMatch > 0) {
                str = str.substring(0, str.length() - longestMatch).trim();
            }
        }
        try {
            return (int)(Double.parseDouble(str) * multiplier);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public Class<?> valueType() {
        return Color.class;
    }

    @Override
    public Object getValue() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }
}

