/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import java.lang.reflect.Field;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.reader.PrimitiveValueTemplate;

public class DoubleElement
extends PrimitiveValueTemplate {
    Double value = 0.0;
    private final TextureMeta.WithUnits units;

    public DoubleElement(TextureMeta.WithUnits units) {
        this.units = units;
    }

    @Override
    public void characters(Theme theme, char[] chars, int start, int length) {
        String str = String.valueOf(chars, start, length);
        double multiplier = 1.0;
        if (this.units != null) {
            String lower = str.toLowerCase();
            int longestMatch = 0;
            for (TextureMeta.Unit u : this.units.value()) {
                for (String unitName : u.names()) {
                    if (!lower.endsWith(unitName.toLowerCase()) || unitName.length() <= longestMatch) continue;
                    multiplier = u.multiplier();
                    longestMatch = unitName.length();
                }
            }
            if (longestMatch > 0) {
                str = str.substring(0, str.length() - longestMatch).trim();
            }
        }
        try {
            this.value = Double.parseDouble(str) * multiplier;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public Class<?> valueType() {
        return Double.class;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean setField(Field field, Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        if (type == Double.class || type == Double.TYPE) {
            field.set(object, this.value);
        } else if (type == Float.class || type == Float.TYPE) {
            field.set(object, Float.valueOf(this.value.floatValue()));
        } else {
            return false;
        }
        return true;
    }
}

