/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.GameRegistry;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSaplingVanilla;
import com.ferreusveritas.dynamictrees.blocks.BlockFruitCocoa;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.blocks.BlockVerboseFire;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class ModBlocks {
    public static BlockRootyDirt blockRootyDirt;
    public static BlockDynamicSapling blockDynamicSapling;
    public static BlockFruitCocoa blockFruitCocoa;
    public static BlockBonsaiPot blockBonsaiPot;
    public static BlockVerboseFire blockVerboseFire;
    public static CommonBlockStates blockStates;

    public static void preInit() {
        blockStates = new CommonBlockStates();
        blockRootyDirt = new BlockRootyDirt();
        blockDynamicSapling = new BlockDynamicSaplingVanilla("sapling");
        blockBonsaiPot = new BlockBonsaiPot();
        blockFruitCocoa = new BlockFruitCocoa();
        blockVerboseFire = new BlockVerboseFire();
    }

    public static void registerBlocks() {
        GameRegistry.register(blockRootyDirt);
        GameRegistry.register(blockDynamicSapling);
        GameRegistry.register(blockBonsaiPot);
        GameRegistry.register(blockFruitCocoa);
        GameRegistry.register(blockVerboseFire);
        ArrayList<BlockBackport> treeBlocks = new ArrayList<BlockBackport>();
        for (DynamicTree tree : ModTrees.baseTrees) {
            tree.getRegisterableBlocks(treeBlocks);
        }
        for (BlockBackport block : treeBlocks) {
            GameRegistry.register(block);
        }
        for (BlockDynamicLeaves leavesBlock : TreeHelper.getLeavesMapForModId("dynamictrees").values()) {
            GameRegistry.register(leavesBlock);
        }
        DynamicTrees.compatProxy.registerBlocks();
    }

    public static class CommonBlockStates {
        public final IBlockState dirt = new BlockState(Blocks.field_150346_d, 0);
        public final IBlockState podzol = new BlockState(Blocks.field_150346_d, 2);
        public final IBlockState redMushroom = new BlockState((Block)Blocks.field_150337_Q);
        public final IBlockState brownMushroom = new BlockState((Block)Blocks.field_150338_P);
    }
}

