/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.backport;

import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.Vec3d;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos
implements Comparable<BlockPos> {
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int xIn, int yIn, int zIn) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
    }

    public BlockPos(Vec3d vec) {
        this(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    public BlockPos(double xIn, double yIn, double zIn) {
        this(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
    }

    public AxisAlignedBB getAxisAlignedBB() {
        return AxisAlignedBB.func_72330_a((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)(this.getX() + 1), (double)(this.getY() + 1), (double)(this.getZ() + 1));
    }

    public BlockPos(Entity source) {
        this((int)Math.floor(source.field_70165_t), (int)Math.floor(source.field_70163_u), (int)Math.floor(source.field_70161_v));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos add(BlockPos pos) {
        return pos.getX() == 0 && pos.getY() == 0 && pos.getZ() == 0 ? this : new BlockPos(this.getX() + pos.getX(), this.getY() + pos.getY(), this.getZ() + pos.getZ());
    }

    public BlockPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos subtract(BlockPos pos) {
        return pos.getX() == 0 && pos.getY() == 0 && pos.getZ() == 0 ? this : new BlockPos(this.getX() - pos.getX(), this.getY() - pos.getY(), this.getZ() - pos.getZ());
    }

    public BlockPos offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(EnumFacing facing, int n) {
        return n == 0 ? this : new BlockPos(this.getX() + facing.getFrontOffsetX() * n, this.getY() + facing.getFrontOffsetY() * n, this.getZ() + facing.getFrontOffsetZ() * n);
    }

    public BlockPos offset(ForgeDirection facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(ForgeDirection facing, int n) {
        return n == 0 ? this : new BlockPos(this.getX() + facing.offsetX * n, this.getY() + facing.offsetY * n, this.getZ() + facing.offsetZ * n);
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos up(int n) {
        return this.offset(EnumFacing.UP, n);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int n) {
        return this.offset(EnumFacing.DOWN, n);
    }

    public String toString() {
        return "pos: " + this.getX() + "," + this.getY() + "," + this.getZ();
    }

    public static Iterable<BlockPos> getAllInBox(BlockPos from, BlockPos to) {
        final BlockPos blockmin = new BlockPos(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()));
        final BlockPos blockmax = new BlockPos(Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private BlockPos lastReturned;

                    protected BlockPos computeNext() {
                        if (this.lastReturned == null) {
                            this.lastReturned = blockmin;
                            return this.lastReturned;
                        }
                        if (this.lastReturned.equals(blockmax)) {
                            return (BlockPos)this.endOfData();
                        }
                        int x = this.lastReturned.getX();
                        int y = this.lastReturned.getY();
                        int z = this.lastReturned.getZ();
                        if (x < blockmax.getX()) {
                            ++x;
                        } else if (y < blockmax.getY()) {
                            x = blockmin.getX();
                            ++y;
                        } else if (z < blockmax.getZ()) {
                            x = blockmin.getX();
                            y = blockmin.getY();
                            ++z;
                        }
                        this.lastReturned = new BlockPos(x, y, z);
                        return this.lastReturned;
                    }
                };
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BlockPos)) {
            return false;
        }
        BlockPos other = (BlockPos)object;
        return this.getX() != other.getX() ? false : (this.getY() != other.getY() ? false : this.getZ() == other.getZ());
    }

    @Override
    public int compareTo(BlockPos compareTo) {
        return this.getY() == compareTo.getY() ? (this.getZ() == compareTo.getZ() ? this.getX() - compareTo.getX() : this.getZ() - compareTo.getZ()) : this.getY() - compareTo.getY();
    }

    public double distanceSq(BlockPos to) {
        return this.distanceSq(to.getX(), to.getY(), to.getZ());
    }

    public double distanceSq(double toX, double toY, double toZ) {
        double d0 = (double)this.getX() - toX;
        double d1 = (double)this.getY() - toY;
        double d2 = (double)this.getZ() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }
}

