/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.backport;

import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.RayTraceResult;
import com.ferreusveritas.dynamictrees.api.backport.Vec3d;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;

public class World
extends BlockAccess {
    private final net.minecraft.world.World world;
    public final boolean isRemote;
    public Random rand;

    public World(net.minecraft.world.World world) {
        super((IBlockAccess)world);
        this.isRemote = world.field_72995_K;
        this.world = world;
        this.rand = world.field_73012_v;
    }

    public net.minecraft.world.World real() {
        return this.world;
    }

    public boolean restoringBlockSnapshots() {
        return this.world.restoringBlockSnapshots;
    }

    public void setBlockState(BlockPos pos, IBlockState blockState, int flags) {
        this.world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), blockState.getBlock(), blockState.getMeta(), flags);
    }

    public void setBlockState(BlockPos pos, IBlockState blockState) {
        this.world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), blockState.getBlock(), blockState.getMeta(), 3);
    }

    public void setBlockState(BlockPos pos, Block block) {
        this.world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), block, 0, 3);
    }

    public int getLightFor(EnumSkyBlock type, BlockPos pos) {
        return this.world.func_72972_b(type, pos.getX(), pos.getY(), pos.getZ());
    }

    public void setBlockToAir(BlockPos pos) {
        this.world.func_147468_f(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockPos getHeight(BlockPos pos) {
        return new BlockPos(pos.getX(), this.world.func_72976_f(pos.getX(), pos.getZ()), pos.getZ());
    }

    @Override
    public Biome getBiome(BlockPos pos) {
        return new Biome(this.world.func_72807_a(pos.getX(), pos.getZ()));
    }

    public boolean canBlockSeeSky(BlockPos pos) {
        return this.world.func_72937_j(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean canMineBlock(EntityPlayer player, int x, int y, int z) {
        return this.world.func_72962_a(player, x, y, z);
    }

    public boolean canMineBlock(EntityPlayer player, BlockPos pos) {
        return this.canMineBlock(player, pos.getX(), pos.getY(), pos.getZ());
    }

    public void playSoundEffect(BlockPos pos, String soundevent, float a, float b) {
        this.world.func_72908_a((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), soundevent, a, b);
    }

    public void playSoundEffect(double x, double y, double z, String soundevent, float a, float b) {
        this.world.func_72908_a(x, y, z, soundevent, a, b);
    }

    public boolean isBlockIndirectlyGettingPowered(BlockPos pos) {
        return this.world.func_72864_z(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean isBlockIndirectlyGettingPowered(int x, int y, int z) {
        return this.world.func_72864_z(x, y, z);
    }

    public static boolean doesBlockHaveSolidTopSurface(World world, BlockPos pos) {
        return net.minecraft.world.World.func_147466_a((IBlockAccess)world.real(), (int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
    }

    public long getTotalWorldTime() {
        return this.world.func_82737_E();
    }

    public void scheduleUpdate(BlockPos pos, Block block, int i) {
        this.world.func_147464_a(pos.getX(), pos.getY(), pos.getZ(), block, i);
    }

    public boolean isBlockinHighHumidity(BlockPos pos) {
        return this.world.func_72958_C(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean isRaining() {
        return this.world.func_72896_J();
    }

    public GameRules getGameRules() {
        return this.world.func_82736_K();
    }

    public EnumDifficulty getDifficulty() {
        return this.world.field_73013_u;
    }

    public boolean isRainingAt(BlockPos pos) {
        return this.world.func_72951_B(pos.getX(), pos.getY(), pos.getZ());
    }

    public RayTraceResult rayTraceBlocks(Vec3d start, Vec3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        MovingObjectPosition mop = this.world.func_147447_a(start.toVec3(), end.toVec3(), stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
        return mop == null ? null : new RayTraceResult(mop);
    }
}

