/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.cells;

import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.cells.CellNormal;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;

public class Cells {
    public static final ICell nullCell = new CellNull();
    public static final ICell branchCell = new CellNormal(5);
    public static final ICell[] normalCells = new ICell[]{nullCell, new CellNormal(1), new CellNormal(2), new CellNormal(3), new CellNormal(4), new CellNormal(5), new CellNormal(6), new CellNormal(7)};
    public static final BasicSolver deciduousSolver = new BasicSolver(new short[]{1300, 1059, 802, 1041, 785, 529});
    public static final BasicSolver coniferSolver = new BasicSolver(new short[]{1300, 1043, 786, 529});
    public static final BasicSolver acaciaSolver = new BasicSolver(new short[]{1300, 1059, 1042, 786, 529});
    public static final BasicSolver darkOakSolver = new BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

    public static int solveCell(int[] nv, short[] solution) {
        for (short d : solution) {
            if (nv[d >> 8 & 0xF] < (d >> 4 & 0xF)) continue;
            return d & 0xF;
        }
        return 0;
    }

    public static class BasicSolver
    implements ICellSolver {
        private final short[] codes;

        public BasicSolver(short[] codes) {
            this.codes = codes;
        }

        @Override
        public int solve(ICell[] cells) {
            int[] nv = new int[16];
            for (EnumFacing dir : EnumFacing.VALUES) {
                int n = cells[dir.ordinal()].getValueFromSide(dir.getOpposite());
                nv[n] = nv[n] + 1;
            }
            return Cells.solveCell(nv, this.codes);
        }
    }
}

