/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.backport.BlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.renderers.RendererBonsai;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockBonsaiPot
extends BlockBackport {
    protected Map<Integer, DynamicTree> trees = new HashMap<Integer, DynamicTree>();
    public static final String name = "bonsaipot";

    public BlockBonsaiPot() {
        this(name);
    }

    public BlockBonsaiPot(String name) {
        super(Blocks.field_150457_bL.func_149688_o());
        this.setDefaultState(new BlockState(this));
        this.setUnlocalizedNameReg(name);
        this.setRegistryName(name);
        this.func_149683_g();
    }

    public void setupVanillaTree(DynamicTree tree) {
        this.trees.put(tree.getPrimitiveSapling().getMeta(), tree);
    }

    public DynamicTree getTree(IBlockState state) {
        if (state.getBlock() == this) {
            return this.trees.get(state.getMeta());
        }
        return this.trees.get(0);
    }

    public boolean setTree(com.ferreusveritas.dynamictrees.api.backport.World world, DynamicTree tree, BlockPos pos) {
        int woodType = tree.getPrimitiveSapling().getMeta();
        world.setBlockState(pos, this.getDefaultState().withMeta(woodType));
        return true;
    }

    public boolean setSpecies(com.ferreusveritas.dynamictrees.api.backport.World world, Species species, BlockPos pos) {
        if (species == species.getTree().getCommonSpecies()) {
            return this.setTree(world, species.getTree(), pos);
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && heldItem == null) {
            DynamicTree tree = this.getTree(state);
            if (!world.isRemote) {
                ItemStack seedStack = tree.getCommonSpecies().getSeedStack(1);
                ItemStack saplingStack = tree.getPrimitiveSapling().toItemStack();
                CompatHelper.spawnEntity(world, (Entity)new EntityItem(world.real(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), player.func_70093_af() ? saplingStack : seedStack));
            }
            world.setBlockState(pos, new BlockState(Blocks.field_150457_bL));
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(Items.field_151162_bE);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Items.field_151162_bE;
    }

    @Override
    public ArrayList<ItemStack> getDrops(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = super.getDrops(world, pos, state, fortune);
        DynamicTree tree = this.getTree(state);
        ret.add(tree.getCommonSpecies().getSeedStack(1));
        return ret;
    }

    @Override
    public void neighborChanged(IBlockState state, com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, Block block) {
        if (!com.ferreusveritas.dynamictrees.api.backport.World.doesBlockHaveSolidTopSurface(world, pos.down())) {
            this.dropBlockAsItem(world, pos, state.getMeta(), 0);
            world.setBlockToAir(pos);
        }
    }

    public void func_149683_g() {
        float f = 0.375f;
        float f1 = f / 2.0f;
        this.func_149676_a(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, f, 0.5f + f1);
    }

    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150457_bL.func_149691_a(side, meta);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RendererBonsai.id;
    }

    public boolean func_149686_d() {
        return false;
    }
}

