/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.backport.BlockContainerBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.ILorable;
import com.ferreusveritas.dynamictrees.api.backport.IRegisterable;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.tileentity.TileEntityDendroCoil;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.Circle;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.worldgen.CircleHelper;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockDendroCoil
extends BlockContainerBackport
implements IPeripheralProvider,
IRegisterable,
ILorable {
    IIcon topIcon;
    IIcon sideIcon;
    IIcon bottomIcon;
    protected String registryName;

    public BlockDendroCoil() {
        this("dendrocoil");
    }

    public BlockDendroCoil(String name) {
        super(Material.field_151573_f);
        this.setUnlocalizedNameReg(name);
        this.func_149647_a(DynamicTrees.dynamicTreesTab);
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)this);
        this.setRegistryName(name);
        GameRegistry.registerTileEntity(TileEntityDendroCoil.class, (String)name);
    }

    @Override
    public void neighborChanged(IBlockState state, com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, Block blockIn) {
        if (world.isBlockIndirectlyGettingPowered(pos)) {
            this.growPulse(world, pos);
        }
    }

    public String getCode(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        if (TreeHelper.isRootyDirt(world, pos = pos.up())) {
            return new JoCode().buildFromTree(world, pos).toString();
        }
        return "";
    }

    public void setCode(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, String treeName, String JoCode2) {
        JoCode jo = new JoCode(JoCode2);
        Species species = TreeRegistry.findSpeciesSloppy(treeName);
        if (species != null) {
            jo.setCareful(true).generate(world, species, pos.up(), world.getBiome(pos), EnumFacing.NORTH, 8);
        } else {
            Logger.getLogger("dynamictrees").log(Level.WARNING, "Tree: " + treeName + " not found.");
        }
    }

    public void createStaff(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, String treeName, String JoCode2, String rgb, boolean readOnly) {
        ItemStack stack = new ItemStack((Item)ModItems.treeStaff, 1, 0);
        Species tree = TreeRegistry.findSpeciesSloppy(treeName);
        ModItems.treeStaff.setSpecies(stack, tree).setCode(stack, JoCode2).setColor(stack, rgb).setReadOnly(stack, readOnly);
        EntityItem entityItem = new EntityItem(world.real(), (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, stack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        CompatHelper.spawnEntity(world, (Entity)entityItem);
    }

    public String getSpecies(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart(world, pos.up());
        if (part.isRootNode()) {
            return DynamicTree.getExactSpecies(world, pos.up()).toString();
        }
        return "";
    }

    public void plantTree(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, String treeName) {
        Species species = TreeRegistry.findSpeciesSloppy(treeName);
        if (species != null) {
            species.getSeed().plantSapling(world, pos.up(2), species.getSeedStack(1));
        }
    }

    public void growPulse(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart(world, pos.up());
        if (part.isRootNode()) {
            TreeHelper.growPulse(world, pos.up());
        }
    }

    public void killTree(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart(world, pos.up());
        if (part.isRootNode()) {
            ((BlockRootyDirt)part).destroyTree(world, pos.up());
        }
    }

    public int getSoilLife(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart(world, pos.up());
        if (part.isRootNode()) {
            return ((BlockRootyDirt)part).getSoilLife(world, pos.up());
        }
        return 0;
    }

    public void setSoilLife(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, int life) {
        ITreePart part = TreeHelper.getSafeTreePart(world, pos.up());
        if (part.isRootNode()) {
            ((BlockRootyDirt)part).setSoilLife(world, pos.up(), life);
        }
    }

    public void testPoisson(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, int rad1, int rad2, double angle) {
        pos = pos.up();
        for (int y = 0; y < 2; ++y) {
            for (int z = -28; z <= 28; ++z) {
                for (int x = -28; x <= 28; ++x) {
                    world.setBlockToAir(pos.add(x, y, z));
                }
            }
        }
        if (rad1 >= 2 && rad2 >= 2 && rad1 <= 8 && rad2 <= 8) {
            Circle circleA = new Circle(pos, rad1);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleA, pos.getY(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            Circle circleB = CircleHelper.findSecondCircle(circleA, rad2, angle);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleB, pos.getY(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            world.setBlockState(new BlockPos(circleB.x, pos.up().getY(), circleB.z), circleB.isLoose() ? Blocks.field_150347_e : Blocks.field_150484_ah);
        }
    }

    public void testPoisson2(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, int rad1, int rad2, double angle, int rad3) {
        pos = pos.up();
        for (int y = 0; y < 2; ++y) {
            for (int z = -28; z <= 28; ++z) {
                for (int x = -28; x <= 28; ++x) {
                    world.setBlockToAir(pos.add(x, y, z));
                }
            }
        }
        if (rad1 >= 2 && rad2 >= 2 && rad1 <= 8 && rad2 <= 8 && rad3 >= 2 && rad3 <= 8) {
            Circle circleA = new Circle(pos, rad1);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleA, pos.getY(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            Circle circleB = CircleHelper.findSecondCircle(circleA, rad2, angle);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleB, pos.getY(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            CircleHelper.maskCircles(circleA, circleB);
            Circle circleC = CircleHelper.findThirdCircle(circleA, circleB, rad3);
            if (circleC != null) {
                TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleC, pos.getY(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            } else {
                System.out.println("Angle:" + angle);
                world.setBlockState(new BlockPos(circleA.x, pos.up().getY(), circleA.z), Blocks.field_150451_bX);
            }
        }
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDendroCoil();
    }

    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDendroCoil) {
            return (TileEntityDendroCoil)te;
        }
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add("\u00a76ComputerCraft Peripheral");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.topIcon = reg.func_94245_a("dynamictrees:coil-top");
        this.sideIcon = reg.func_94245_a("dynamictrees:coil-side");
        this.bottomIcon = reg.func_94245_a("dynamictrees:coil-bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon);
    }
}

